/*
 * Decompiled with CFR 0.152.
 */
package Tech_Nagendra.Certificates_genration.Controller;

import Tech_Nagendra.Certificates_genration.Dto.AuthRequest;
import Tech_Nagendra.Certificates_genration.Dto.AuthResponse;
import Tech_Nagendra.Certificates_genration.Entity.UserProfile;
import Tech_Nagendra.Certificates_genration.Repository.ProfileRepository;
import Tech_Nagendra.Certificates_genration.Service.ProfileService;
import Tech_Nagendra.Certificates_genration.Utility.JwtUtil;
import io.jsonwebtoken.Claims;
import jakarta.servlet.http.HttpSession;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/auth"})
@CrossOrigin(origins={"http://genkart.in"}, allowCredentials="true")
public class AuthController {
    private final AuthenticationManager authenticationManager;
    private final JwtUtil jwtUtil;
    private final ProfileRepository profileRepository;
    private final ProfileService profileService;

    @PostMapping(value={"/login"})
    public ResponseEntity<AuthResponse> login(@RequestBody AuthRequest request, HttpSession session) {
        try {
            this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)request.getUsername(), (Object)request.getPassword()));
            UserProfile userProfile = (UserProfile)this.profileRepository.findByUsername(request.getUsername()).orElseThrow(() -> new RuntimeException("User not found"));
            String token = this.jwtUtil.generateToken(userProfile.getId(), userProfile.getUsername(), userProfile.getEmail(), userProfile.getRole());
            this.profileService.saveLoginToken(userProfile.getId(), token);
            session.setAttribute("JWT_TOKEN", (Object)token);
            Claims claims = this.jwtUtil.extractAllClaims(token);
            System.out.println("Generated JWT Claims -> userId: " + claims.get((Object)"userId") + ", username: " + claims.getSubject() + ", role: " + claims.get((Object)"role"));
            return ResponseEntity.ok((Object)new AuthResponse(true, 200, "Login successful", userProfile.getUsername(), userProfile.getEmail(), token));
        }
        catch (BadCredentialsException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)new AuthResponse(false, 401, "Invalid username or password", null, null, null));
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)new AuthResponse(false, 500, "Internal server error: " + e.getMessage(), null, null, null));
        }
    }

    @PostMapping(value={"/logout"})
    public ResponseEntity<AuthResponse> logout(@RequestHeader(value="Authorization", required=false) String tokenHeader, HttpSession session) {
        try {
            if (tokenHeader != null && tokenHeader.startsWith("Bearer ")) {
                String token = tokenHeader.substring(7).trim();
                Long userId = this.jwtUtil.extractUserId(token);
                if (userId != null) {
                    this.profileService.saveLoginToken(userId, null);
                    session.removeAttribute("JWT_TOKEN");
                } else {
                    return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)new AuthResponse(false, 401, "Invalid token", null, null, null));
                }
            }
            return ResponseEntity.ok((Object)new AuthResponse(true, 200, "Logout successful", null, null, null));
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)new AuthResponse(false, 500, "Logout failed: " + e.getMessage(), null, null, null));
        }
    }

    public AuthController(AuthenticationManager authenticationManager, JwtUtil jwtUtil, ProfileRepository profileRepository, ProfileService profileService) {
        this.authenticationManager = authenticationManager;
        this.jwtUtil = jwtUtil;
        this.profileRepository = profileRepository;
        this.profileService = profileService;
    }
}

