/*
 * Decompiled with CFR 0.152.
 */
package Tech_Nagendra.Certificates_genration.Controller;

import Tech_Nagendra.Certificates_genration.Entity.CandidateDTO;
import Tech_Nagendra.Certificates_genration.Entity.UserProfile;
import Tech_Nagendra.Certificates_genration.Repository.ProfileRepository;
import Tech_Nagendra.Certificates_genration.Security.UserPrincipal;
import Tech_Nagendra.Certificates_genration.Service.CertificateService;
import Tech_Nagendra.Certificates_genration.Service.DynamicFontService;
import Tech_Nagendra.Certificates_genration.Service.ReportService;
import Tech_Nagendra.Certificates_genration.Utility.JwtUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/certificates"})
@CrossOrigin(origins={"http://localhost:8081"}, allowCredentials="true")
public class CertificateController {
    private static final Logger logger = LoggerFactory.getLogger(CertificateController.class);
    private final CertificateService certificateService;
    private final ReportService reportService;
    private final ProfileRepository profileRepository;
    private final JwtUtil jwtUtil;
    private final DynamicFontService dynamicFontService;
    @Value(value="${certificate.template.path:${user.dir}/templates/}")
    private String tempPath;

    public CertificateController(CertificateService certificateService, ReportService reportService, ProfileRepository profileRepository, JwtUtil jwtUtil, DynamicFontService dynamicFontService) {
        this.certificateService = certificateService;
        this.reportService = reportService;
        this.profileRepository = profileRepository;
        this.jwtUtil = jwtUtil;
        this.dynamicFontService = dynamicFontService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping(value={"/generate-zip/{templateId}"}, consumes={"multipart/form-data"})
    public ResponseEntity<?> generateCertificatesZip(@PathVariable Long templateId, @RequestPart(value="excel") MultipartFile excelFile, @RequestPart(value="zipImage", required=false) MultipartFile zipImage, @RequestPart(value="logo", required=false) MultipartFile logo, @RequestPart(value="sign", required=false) MultipartFile sign, @RequestHeader(value="Authorization") String tokenHeader) {
        HashMap uploadedFiles = new HashMap();
        File tempExcel = null;
        File dir = new File(this.tempPath);
        try {
            FileOutputStream fos;
            if (excelFile == null || excelFile.isEmpty()) {
                ResponseEntity responseEntity = ResponseEntity.badRequest().body(Map.of("error", "Excel file is required"));
                return responseEntity;
            }
            String token = tokenHeader.startsWith("Bearer ") ? tokenHeader.substring(7) : tokenHeader;
            Long userId = this.jwtUtil.extractUserId(token);
            UserProfile userProfile = (UserProfile)this.profileRepository.findById((Object)userId).orElseThrow(() -> new RuntimeException("User not found with id: " + userId));
            UserPrincipal currentUser = new UserPrincipal(userProfile);
            if (!dir.exists() && !dir.mkdirs()) {
                throw new RuntimeException("Failed to create directory: " + this.tempPath);
            }
            tempExcel = new File(dir, System.currentTimeMillis() + "_" + excelFile.getOriginalFilename());
            try (InputStream in = excelFile.getInputStream();){
                fos = new FileOutputStream(tempExcel);
                try {
                    in.transferTo(fos);
                }
                finally {
                    fos.close();
                }
            }
            this.saveTempFile(uploadedFiles, zipImage, dir, "zipImage");
            this.saveTempFile(uploadedFiles, logo, dir, "logo");
            this.saveTempFile(uploadedFiles, sign, dir, "sign");
            Map result = this.certificateService.generateCertificatesAndReports(templateId, tempExcel, uploadedFiles.isEmpty() ? null : uploadedFiles, this.tempPath, currentUser);
            if (result.containsKey("error") && ((Boolean)result.get("error")).booleanValue()) {
                fos = ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Map.of("error", "Certificate generation failed", "message", result.get("message")));
                this.cleanupTempFiles(tempExcel, uploadedFiles);
                return fos;
            }
            List pdfFiles = result.getOrDefault("pdfFiles", new ArrayList());
            List candidates = result.getOrDefault("candidates", new ArrayList());
            if (pdfFiles.isEmpty()) {
                ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Map.of("error", "No PDF files generated"));
                this.cleanupTempFiles(tempExcel, uploadedFiles);
                return responseEntity;
            }
            for (CandidateDTO candidate : candidates) {
                try {
                    this.reportService.saveCandidateReport((Object)candidate, templateId, userId, currentUser);
                }
                catch (Exception exception) {}
            }
            File outputFolder = new File(this.tempPath);
            List finalPdfList = this.performMergeIfNeeded(outputFolder, candidates, pdfFiles);
            byte[] zipBytes = this.createZipBytesFromCandidates(finalPdfList, candidates);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDisposition(ContentDisposition.builder((String)"attachment").filename("certificates_" + System.currentTimeMillis() + ".zip").build());
            headers.setContentLength((long)zipBytes.length);
            ResponseEntity responseEntity = new ResponseEntity((Object)zipBytes, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
            this.cleanupTempFiles(tempExcel, uploadedFiles);
            return responseEntity;
        }
        catch (Exception e) {
            logger.error("Certificate generation failed", (Throwable)e);
            ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Map.of("error", "Certificate generation failed", "message", e.getMessage()));
            return responseEntity;
        }
        finally {
            this.cleanupTempFiles(tempExcel, uploadedFiles);
        }
    }

    private List<File> performMergeIfNeeded(File outputFolder, List<CandidateDTO> candidates, List<File> generatedPdfs) {
        try {
            String sid;
            logger.info("Checking for Type 4 and Type 5 certificates to merge...");
            HashMap<String, CandidateDTO> sidToCandidate = new HashMap<String, CandidateDTO>();
            for (CandidateDTO candidate : candidates) {
                if (candidate.getSid() == null || candidate.getSid().trim().isEmpty()) continue;
                sidToCandidate.put(candidate.getSid().trim(), candidate);
            }
            File[] allPdfs = outputFolder.listFiles((d, name) -> name.toLowerCase().endsWith(".pdf"));
            if (allPdfs == null || allPdfs.length == 0) {
                logger.info("No PDF files found in output folder for merging");
                return generatedPdfs;
            }
            HashMap<String, List> groupedBySid = new HashMap<String, List>();
            for (File pdfFile : allPdfs) {
                sid = this.extractSidFromFilename(pdfFile.getName());
                if (sid == null || sid.trim().isEmpty()) continue;
                groupedBySid.computeIfAbsent(sid, k -> new ArrayList()).add(pdfFile);
            }
            logger.info("Found {} unique SIDs with PDF files", (Object)groupedBySid.size());
            HashMap<String, File> mergedFilesMap = new HashMap<String, File>();
            int mergeCount = 0;
            for (Map.Entry entry : groupedBySid.entrySet()) {
                sid = (String)entry.getKey();
                List pdfList = (List)entry.getValue();
                boolean hasType4 = false;
                boolean hasType5 = false;
                File type4File = null;
                File type5File = null;
                for (File pdf : pdfList) {
                    String fileName = pdf.getName().toLowerCase();
                    if (fileName.contains("type4")) {
                        hasType4 = true;
                        type4File = pdf;
                        continue;
                    }
                    if (!fileName.contains("type5")) continue;
                    hasType5 = true;
                    type5File = pdf;
                }
                if (!hasType4 || !hasType5 || type4File == null || type5File == null) continue;
                try {
                    File mergedFile = this.mergeType4AndType5Certificates(type4File, type5File, sid, (CandidateDTO)sidToCandidate.get(sid), outputFolder);
                    if (mergedFile == null) continue;
                    mergedFilesMap.put(sid, mergedFile);
                    ++mergeCount;
                    logger.info("Successfully merged Type 4 and Type 5 for SID: {}", (Object)sid);
                    type4File.delete();
                    type5File.delete();
                }
                catch (Exception e) {
                    logger.error("Failed to merge certificates for SID {}: {}", (Object)sid, (Object)e.getMessage());
                }
            }
            logger.info("Successfully merged {} pairs of Type 4 and Type 5 certificates", (Object)mergeCount);
            ArrayList<File> finalPdfList = new ArrayList<File>();
            for (CandidateDTO candidate : candidates) {
                String sid2 = candidate.getSid();
                if (sid2 == null || sid2.trim().isEmpty()) continue;
                if (mergedFilesMap.containsKey(sid2)) {
                    finalPdfList.add((File)mergedFilesMap.get(sid2));
                    continue;
                }
                File individualFile = this.findPdfForCandidate(outputFolder, candidate);
                if (individualFile == null || !individualFile.exists()) continue;
                finalPdfList.add(individualFile);
            }
            logger.info("Final PDF list contains {} files", (Object)finalPdfList.size());
            return finalPdfList;
        }
        catch (Exception e) {
            logger.error("Error during certificate merging process: {}", (Object)e.getMessage(), (Object)e);
            return generatedPdfs;
        }
    }

    private File mergeType4AndType5Certificates(File type4File, File type5File, String sid, CandidateDTO candidate, File outputFolder) {
        try {
            String safeName = "Unknown";
            if (candidate != null && candidate.getCandidateName() != null) {
                safeName = candidate.getCandidateName().replaceAll("[^a-zA-Z0-9\\-_ ]", "_").trim();
            }
            String mergedFileName = safeName + "_" + sid + ".pdf";
            File mergedFile = new File(outputFolder, mergedFileName);
            PDFMergerUtility merger = new PDFMergerUtility();
            merger.addSource(type4File);
            merger.addSource(type5File);
            merger.setDestinationFileName(mergedFile.getAbsolutePath());
            merger.mergeDocuments(MemoryUsageSetting.setupMainMemoryOnly());
            logger.info("Created merged PDF: {}", (Object)mergedFile.getName());
            return mergedFile;
        }
        catch (Exception e) {
            logger.error("Failed to merge PDFs for SID {}: {}", new Object[]{sid, e.getMessage(), e});
            return null;
        }
    }

    private String extractSidFromFilename(String filename) {
        if (filename == null || filename.trim().isEmpty()) {
            return null;
        }
        try {
            String firstPart;
            String[] parts;
            String nameWithoutExt = filename;
            if (nameWithoutExt.toLowerCase().endsWith(".pdf")) {
                nameWithoutExt = nameWithoutExt.substring(0, nameWithoutExt.length() - 4);
            }
            for (String part : parts = nameWithoutExt.split("_")) {
                if (!part.matches("^[A-Za-z0-9-]{3,50}$") || part.toLowerCase().matches("type4|type5|merged|certificate|cert")) continue;
                return part;
            }
            if (parts.length > 0 && !(firstPart = parts[0]).toLowerCase().matches("type4|type5|merged|certificate|cert|unknown")) {
                return firstPart;
            }
            return null;
        }
        catch (Exception e) {
            logger.warn("Error extracting SID from filename '{}': {}", (Object)filename, (Object)e.getMessage());
            return null;
        }
    }

    private File findPdfForCandidate(File folder, CandidateDTO candidate) {
        if (candidate == null || candidate.getSid() == null) {
            return null;
        }
        String sid = candidate.getSid().trim();
        File[] pdfFiles = folder.listFiles((d, name) -> name.toLowerCase().endsWith(".pdf"));
        if (pdfFiles == null) {
            return null;
        }
        for (File pdfFile : pdfFiles) {
            String fileName = pdfFile.getName();
            if (fileName.contains("_merged.")) continue;
            if (fileName.contains(sid)) {
                return pdfFile;
            }
            String extractedSid = this.extractSidFromFilename(fileName);
            if (!sid.equals(extractedSid)) continue;
            return pdfFile;
        }
        return null;
    }

    private byte[] createZipBytesFromCandidates(List<File> pdfFiles, List<CandidateDTO> candidates) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ZipOutputStream zos = new ZipOutputStream(baos);){
            HashMap<String, CandidateDTO> sidToCandidate = new HashMap<String, CandidateDTO>();
            for (CandidateDTO candidate : candidates) {
                if (candidate.getSid() == null) continue;
                sidToCandidate.put(candidate.getSid(), candidate);
            }
            for (File pdfFile : pdfFiles) {
                if (pdfFile == null || !pdfFile.exists()) continue;
                String sid = this.extractSidFromFilename(pdfFile.getName());
                CandidateDTO candidate = (CandidateDTO)sidToCandidate.get(sid);
                String candidateName = "Certificate";
                if (candidate != null && candidate.getCandidateName() != null) {
                    candidateName = candidate.getCandidateName().replaceAll("[^a-zA-Z0-9.-]", "_");
                }
                String zipEntryName = sid != null ? candidateName + "_" + sid + ".pdf" : candidateName + "_" + System.currentTimeMillis() + ".pdf";
                zos.putNextEntry(new ZipEntry(zipEntryName));
                Files.copy(pdfFile.toPath(), zos);
                zos.closeEntry();
                logger.debug("Added to ZIP: {}", (Object)zipEntryName);
            }
        }
        logger.info("Created ZIP file with {} PDF entries", (Object)pdfFiles.size());
        return baos.toByteArray();
    }

    private void saveTempFile(Map<String, File> uploadedFiles, MultipartFile file, File dir, String key) throws IOException {
        if (file != null && !file.isEmpty()) {
            File temp = new File(dir, System.currentTimeMillis() + "_" + file.getOriginalFilename());
            try (InputStream in = file.getInputStream();
                 FileOutputStream fos = new FileOutputStream(temp);){
                in.transferTo(fos);
            }
            uploadedFiles.put(key, temp);
            logger.info("Saved temporary file: {}", (Object)temp.getName());
        }
    }

    private void cleanupTempFiles(File excelFile, Map<String, File> uploadedFiles) {
        try {
            int deletedCount = 0;
            if (excelFile != null && excelFile.exists() && excelFile.delete()) {
                ++deletedCount;
            }
            for (File file : uploadedFiles.values()) {
                if (file == null || !file.exists() || !file.delete()) continue;
                ++deletedCount;
            }
            logger.info("Cleaned up {} temporary files", (Object)deletedCount);
        }
        catch (Exception e) {
            logger.warn("Error during temporary file cleanup: {}", (Object)e.getMessage());
        }
    }

    @GetMapping(value={"/reports/all"})
    public ResponseEntity<?> getAllReports(@RequestHeader(value="Authorization") String tokenHeader) {
        try {
            String token = tokenHeader.startsWith("Bearer ") ? tokenHeader.substring(7) : tokenHeader;
            Long userId = this.jwtUtil.extractUserId(token);
            UserProfile userProfile = (UserProfile)this.profileRepository.findById((Object)userId).orElseThrow(() -> new RuntimeException("User not found"));
            UserPrincipal currentUser = new UserPrincipal(userProfile);
            List reports = this.reportService.getAllReports(currentUser);
            return ResponseEntity.ok((Object)reports);
        }
        catch (Exception e) {
            logger.error("Error fetching reports: {}", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Map.of("error", e.getMessage()));
        }
    }

    @GetMapping(value={"/reports/count/month"})
    public ResponseEntity<?> countReportsThisMonth() {
        try {
            Long count = this.reportService.countCertificatesThisMonth();
            return ResponseEntity.ok(Map.of("count", count));
        }
        catch (Exception e) {
            logger.error("Error counting monthly reports: {}", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Map.of("error", e.getMessage()));
        }
    }

    @GetMapping(value={"/fonts/status"})
    public ResponseEntity<?> getFontStatus() {
        try {
            return ResponseEntity.ok((Object)this.dynamicFontService.getFontInfo());
        }
        catch (Exception e) {
            logger.error("Error getting font status: {}", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Map.of("error", e.getMessage()));
        }
    }

    @PostMapping(value={"/fonts/reload"})
    public ResponseEntity<?> reloadFonts() {
        try {
            this.dynamicFontService.reloadFonts();
            return ResponseEntity.ok(Map.of("message", "Fonts reloaded successfully"));
        }
        catch (Exception e) {
            logger.error("Error reloading fonts: {}", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Map.of("error", e.getMessage()));
        }
    }

    @GetMapping(value={"/fonts/available"})
    public ResponseEntity<?> getAvailableFonts() {
        try {
            Set available = this.dynamicFontService.getAvailableFontFamilies();
            return ResponseEntity.ok(Map.of("availableFonts", available, "totalFonts", available.size()));
        }
        catch (Exception e) {
            logger.error("Error getting available fonts: {}", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Map.of("error", e.getMessage()));
        }
    }

    @GetMapping(value={"/fonts/check/{fontName}"})
    public ResponseEntity<?> checkFont(@PathVariable String fontName) {
        try {
            boolean available = this.dynamicFontService.isFontFamilyAvailable(fontName);
            return ResponseEntity.ok(Map.of("fontName", fontName, "available", available));
        }
        catch (Exception e) {
            logger.error("Error checking font {}: {}", (Object)fontName, (Object)e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Map.of("error", e.getMessage()));
        }
    }

    @GetMapping(value={"/health"})
    public ResponseEntity<Map<String, Object>> healthCheck() {
        HashMap<String, Object> health = new HashMap<String, Object>();
        File tempDir = new File(this.tempPath);
        health.put("status", "UP");
        health.put("service", "Certificate Generation");
        health.put("timestamp", new Date());
        health.put("tempDirectoryExists", tempDir.exists());
        health.put("tempDirectoryWritable", tempDir.canWrite());
        health.put("tempDirectoryPath", tempDir.getAbsolutePath());
        return ResponseEntity.ok(health);
    }

    @GetMapping(value={"/status/{templateId}"})
    public ResponseEntity<?> getGenerationStatus(@PathVariable Long templateId) {
        return ResponseEntity.ok(Map.of("templateId", templateId, "status", "ready", "message", "Certificate generation service is active", "timestamp", new Date()));
    }

    @PostMapping(value={"/merge-certificates"})
    public ResponseEntity<?> mergeCertificates(@RequestParam String outputFolderPath) {
        try {
            File outputFolder = new File(outputFolderPath);
            if (!outputFolder.exists() || !outputFolder.isDirectory()) {
                return ResponseEntity.badRequest().body(Map.of("error", "Output folder does not exist"));
            }
            List mergedFiles = this.performManualMerge(outputFolder);
            return ResponseEntity.ok(Map.of("message", "Certificate merging completed", "mergedCount", mergedFiles.size(), "mergedFiles", mergedFiles.stream().map(File::getName).toList()));
        }
        catch (Exception e) {
            logger.error("Manual certificate merging failed: {}", (Object)e.getMessage(), (Object)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Map.of("error", "Certificate merging failed", "message", e.getMessage()));
        }
    }

    private List<File> performManualMerge(File outputFolder) {
        ArrayList<File> mergedFiles = new ArrayList<File>();
        try {
            File[] allPdfs = outputFolder.listFiles((d, name) -> name.toLowerCase().endsWith(".pdf"));
            if (allPdfs == null) {
                return mergedFiles;
            }
            HashMap<String, List> groupedBySid = new HashMap<String, List>();
            for (File pdf : allPdfs) {
                String sid = this.extractSidFromFilename(pdf.getName());
                if (sid == null) continue;
                groupedBySid.computeIfAbsent(sid, k -> new ArrayList()).add(pdf);
            }
            for (Map.Entry entry : groupedBySid.entrySet()) {
                File merged;
                String sid = (String)entry.getKey();
                List pdfList = (List)entry.getValue();
                File type4 = null;
                File type5 = null;
                for (File pdf : pdfList) {
                    if (pdf.getName().contains("type4")) {
                        type4 = pdf;
                        continue;
                    }
                    if (!pdf.getName().contains("type5")) continue;
                    type5 = pdf;
                }
                if (type4 == null || type5 == null || (merged = this.mergeType4AndType5Certificates(type4, type5, sid, null, outputFolder)) == null) continue;
                mergedFiles.add(merged);
                type4.delete();
                type5.delete();
            }
        }
        catch (Exception e) {
            logger.error("Manual merge failed: {}", (Object)e.getMessage(), (Object)e);
        }
        return mergedFiles;
    }
}

