/*
 * Decompiled with CFR 0.152.
 */
package Tech_Nagendra.Certificates_genration.Controller;

import Tech_Nagendra.Certificates_genration.Dto.ProfileDto;
import Tech_Nagendra.Certificates_genration.Dto.ProfileStatsDto;
import Tech_Nagendra.Certificates_genration.Dto.UpdatePasswordDto;
import Tech_Nagendra.Certificates_genration.Service.ProfileService;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/profile"})
@CrossOrigin(origins={"http://localhost:8081"}, allowCredentials="true")
public class ProfileController {
    private final ProfileService profileService;

    private String extractToken(String header) {
        if (header == null || !header.startsWith("Bearer ")) {
            throw new IllegalArgumentException("Authorization header must be provided in the format 'Bearer <token>'");
        }
        return header.substring(7).trim();
    }

    @GetMapping
    public ResponseEntity<?> getProfile(@RequestHeader(value="Authorization", required=false) String tokenHeader) {
        try {
            String token = this.extractToken(tokenHeader);
            ProfileDto profile = this.profileService.getProfile(token);
            return ResponseEntity.ok((Object)profile);
        }
        catch (IllegalArgumentException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)e.getMessage());
        }
        catch (ResponseStatusException e) {
            return ResponseEntity.status((HttpStatusCode)e.getStatusCode()).body((Object)e.getReason());
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to fetch profile: " + e.getMessage()));
        }
    }

    @PutMapping
    public ResponseEntity<?> updateProfile(@RequestHeader(value="Authorization", required=false) String tokenHeader, @RequestBody ProfileDto profileDto) {
        try {
            String token = this.extractToken(tokenHeader);
            ProfileDto updatedProfile = this.profileService.updateProfile(token, profileDto);
            return ResponseEntity.ok((Object)updatedProfile);
        }
        catch (IllegalArgumentException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)e.getMessage());
        }
        catch (ResponseStatusException e) {
            return ResponseEntity.status((HttpStatusCode)e.getStatusCode()).body((Object)e.getReason());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to update profile: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/register"})
    public ResponseEntity<?> registerUser(@RequestBody ProfileDto profileDto, @RequestHeader(value="Authorization", required=false) String tokenHeader) {
        try {
            String token = null;
            if (tokenHeader != null && tokenHeader.startsWith("Bearer ")) {
                token = this.extractToken(tokenHeader);
                System.out.println("Registration requested with JWT: " + token);
            }
            if (profileDto.getPassword() == null || profileDto.getPassword().isEmpty()) {
                return ResponseEntity.badRequest().body((Object)"Password is required.");
            }
            ProfileDto newUser = this.profileService.registerUser(profileDto, profileDto.getPassword());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)newUser);
        }
        catch (ResponseStatusException e) {
            return ResponseEntity.status((HttpStatusCode)e.getStatusCode()).body((Object)e.getReason());
        }
        catch (IllegalArgumentException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to register user: " + e.getMessage()));
        }
    }

    @PutMapping(value={"/password"})
    public ResponseEntity<?> updatePassword(@RequestHeader(value="Authorization", required=false) String tokenHeader, @RequestBody UpdatePasswordDto passwordDto) {
        try {
            String token = this.extractToken(tokenHeader);
            boolean updated = this.profileService.updatePassword(token, passwordDto);
            if (updated) {
                return ResponseEntity.ok((Object)"Password updated successfully");
            }
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"Current password is incorrect");
        }
        catch (IllegalArgumentException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to update password: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/all"})
    public ResponseEntity<?> getAllUsers(@RequestHeader(value="Authorization", required=false) String tokenHeader) {
        try {
            String token = this.extractToken(tokenHeader);
            return ResponseEntity.ok((Object)this.profileService.getAllUsers(token));
        }
        catch (IllegalArgumentException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)e.getMessage());
        }
        catch (ResponseStatusException e) {
            return ResponseEntity.status((HttpStatusCode)e.getStatusCode()).body((Object)e.getReason());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to fetch users: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/stats"})
    public ResponseEntity<?> getStats(@RequestHeader(value="Authorization", required=false) String tokenHeader) {
        try {
            String token = this.extractToken(tokenHeader);
            ProfileStatsDto stats = this.profileService.getStats(token);
            return ResponseEntity.ok((Object)stats);
        }
        catch (IllegalArgumentException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)e.getMessage());
        }
        catch (ResponseStatusException e) {
            return ResponseEntity.status((HttpStatusCode)e.getStatusCode()).body((Object)e.getReason());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to fetch stats: " + e.getMessage()));
        }
    }

    public ProfileController(ProfileService profileService) {
        this.profileService = profileService;
    }
}

