/*
 * Decompiled with CFR 0.152.
 */
package Tech_Nagendra.Certificates_genration.Controller;

import Tech_Nagendra.Certificates_genration.Dto.ReportDTO;
import Tech_Nagendra.Certificates_genration.Entity.Report;
import Tech_Nagendra.Certificates_genration.Repository.ProfileRepository;
import Tech_Nagendra.Certificates_genration.Security.UserPrincipal;
import Tech_Nagendra.Certificates_genration.Service.ReportService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/reports"})
@CrossOrigin(origins={"http://localhost:8081"}, allowCredentials="true")
public class ReportController {
    private static final Logger log = LoggerFactory.getLogger(ReportController.class);
    @Autowired
    private ReportService reportService;
    @Autowired
    private ProfileRepository userProfileRepository;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    private UserPrincipal getCurrentUser() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth == null) {
            return null;
        }
        Object principal = auth.getPrincipal();
        if (principal instanceof UserPrincipal) {
            return (UserPrincipal)principal;
        }
        return null;
    }

    private boolean isAdmin(UserPrincipal user) {
        return user != null && user.getAuthorities().stream().anyMatch(a -> a.getAuthority().equalsIgnoreCase("ADMIN") || a.getAuthority().equalsIgnoreCase("ROLE_ADMIN"));
    }

    private ReportDTO convertToDTO(Report report) {
        ReportDTO dto = new ReportDTO();
        dto.setId(report.getId());
        dto.setSid(report.getSid());
        dto.setCourseName(report.getCandidateName());
        dto.setGrade(report.getGrade());
        dto.setTemplateName(report.getTemplateName());
        dto.setJobrole(report.getJobrole());
        dto.setLevel(report.getLevel());
        dto.setBatchId(report.getBatchId());
        dto.setTrainingPartner(report.getTrainingPartner());
        dto.setGeneratedById(report.getGeneratedBy() != null ? report.getGeneratedBy().getId() : null);
        dto.setUserProfileId(report.getUserProfile() != null ? report.getUserProfile().getId() : null);
        dto.setTemplateId(report.getTemplate() != null ? report.getTemplate().getId() : null);
        dto.setStatus(report.getStatus());
        dto.setGeneratedOn(report.getGeneratedOn() != null ? report.getGeneratedOn().toString() : null);
        return dto;
    }

    @GetMapping(value={"/all"})
    public ResponseEntity<List<ReportDTO>> getAllReports() {
        UserPrincipal currentUser = this.getCurrentUser();
        if (currentUser == null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
        }
        List reports = this.reportService.getAllReports(currentUser);
        List dtos = reports.stream().map(arg_0 -> this.convertToDTO(arg_0)).collect(Collectors.toList());
        return ResponseEntity.ok(dtos);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<ReportDTO> getReportById(@PathVariable Long id) {
        UserPrincipal currentUser = this.getCurrentUser();
        if (currentUser == null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
        }
        Report report = this.reportService.getReportById(id);
        if (report == null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build();
        }
        if (!this.isAdmin(currentUser) && !report.getGeneratedBy().getId().equals(currentUser.getId())) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).build();
        }
        return ResponseEntity.ok((Object)this.convertToDTO(report));
    }

    @GetMapping(value={"/filter"})
    public ResponseEntity<List<ReportDTO>> getReportsByFilter(@RequestParam(required=false) String status, @RequestParam(required=false) String searchTerm, @RequestParam(required=false) String fromDate, @RequestParam(required=false) String toDate) {
        UserPrincipal currentUser = this.getCurrentUser();
        if (currentUser == null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
        }
        Date from = null;
        Date to = null;
        try {
            if (fromDate != null && !fromDate.isEmpty()) {
                from = this.dateFormat.parse(fromDate);
            }
            if (toDate != null && !toDate.isEmpty()) {
                to = this.dateFormat.parse(toDate);
            }
        }
        catch (ParseException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).build();
        }
        ArrayList reports = this.reportService.getReportsByMultipleFilters(from, to, status, searchTerm, currentUser);
        if (reports == null) {
            reports = new ArrayList();
        }
        return ResponseEntity.ok((Object)reports);
    }

    @GetMapping(value={"/date-range"})
    public ResponseEntity<List<ReportDTO>> getReportsByDateRange(@RequestParam String startDate, @RequestParam String endDate) {
        UserPrincipal currentUser = this.getCurrentUser();
        if (currentUser == null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
        }
        Date start = null;
        Date end = null;
        try {
            start = this.dateFormat.parse(startDate);
            end = this.dateFormat.parse(endDate);
        }
        catch (ParseException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body(Collections.emptyList());
        }
        List reports = this.reportService.getReportDTOsByDateRange(start, end, currentUser);
        return ResponseEntity.ok((Object)reports);
    }

    @GetMapping(value={"/stats/date-range"})
    public ResponseEntity<Map<String, Object>> getCertificateStatsByDateRange(@RequestParam String startDate, @RequestParam String endDate) {
        UserPrincipal currentUser = this.getCurrentUser();
        if (currentUser == null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
        }
        Date start = null;
        Date end = null;
        try {
            start = this.dateFormat.parse(startDate);
            end = this.dateFormat.parse(endDate);
        }
        catch (ParseException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body(Collections.emptyMap());
        }
        Map stats = this.reportService.getCertificateStatsByDateRange(start, end, currentUser);
        return ResponseEntity.ok((Object)stats);
    }

    @PostMapping(value={"/save"})
    public ResponseEntity<ReportDTO> saveReport(@RequestBody Report report) {
        if (report == null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).build();
        }
        UserPrincipal currentUser = this.getCurrentUser();
        if (currentUser == null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
        }
        Report savedReport = this.reportService.saveOrUpdateBySid(report, currentUser);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)this.convertToDTO(savedReport));
    }

    @PostMapping(value={"/saveAll"})
    public ResponseEntity<Void> saveAllReports(@RequestBody List<Report> reports) {
        if (reports == null || reports.isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).build();
        }
        UserPrincipal currentUser = this.getCurrentUser();
        if (currentUser == null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
        }
        this.reportService.saveOrUpdateAllBySid(reports, currentUser);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).build();
    }

    @PostMapping(value={"/candidate/{templateId}/{userId}"})
    public ResponseEntity<ReportDTO> saveCandidateReport(@RequestBody Object candidateDTO, @PathVariable Long templateId, @PathVariable Long userId) {
        UserPrincipal currentUser = this.getCurrentUser();
        if (currentUser == null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
        }
        Report report = this.reportService.saveCandidateReport(candidateDTO, templateId, userId, currentUser);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)this.convertToDTO(report));
    }

    @GetMapping(value={"/count"})
    public ResponseEntity<Long> countReports() {
        UserPrincipal currentUser = this.getCurrentUser();
        if (currentUser == null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
        }
        Long count = this.reportService.getTotalCertificatesCount(currentUser);
        return ResponseEntity.ok((Object)count);
    }

    @GetMapping(value={"/count/month"})
    public ResponseEntity<Long> countReportsThisMonth() {
        UserPrincipal currentUser = this.getCurrentUser();
        if (currentUser == null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
        }
        Long count = this.isAdmin(currentUser) ? this.reportService.countCertificatesThisMonth() : this.reportService.countCertificatesThisMonthByUser(currentUser.getId());
        return ResponseEntity.ok((Object)count);
    }

    @GetMapping(value={"/monthly"})
    public ResponseEntity<Map<String, Long>> getMonthlyCertificateStats() {
        UserPrincipal currentUser = this.getCurrentUser();
        if (currentUser == null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
        }
        Map stats = this.isAdmin(currentUser) ? this.reportService.getMonthlyCertificateStats() : this.reportService.getMonthlyCertificateStatsByUser(currentUser.getId());
        return ResponseEntity.ok((Object)stats);
    }

    @GetMapping(value={"/types"})
    public ResponseEntity<Map<String, Long>> getCertificateTypesDistribution() {
        UserPrincipal currentUser = this.getCurrentUser();
        if (currentUser == null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
        }
        Map distribution = this.reportService.getCertificateTypesDistribution(currentUser);
        return ResponseEntity.ok((Object)distribution);
    }

    @PostMapping(value={"/certificates/generate"})
    public ResponseEntity<List<ReportDTO>> generateCertificates(@RequestBody Map<String, Object> request) {
        UserPrincipal currentUser = this.getCurrentUser();
        if (currentUser == null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
        }
        List templateIdsInt = (List)request.get("templateIds");
        String sid = (String)request.get("sid");
        List templateIds = templateIdsInt.stream().map(Long::valueOf).collect(Collectors.toList());
        List generated = this.reportService.generateCertificates(currentUser, templateIds, sid);
        List dtos = generated.stream().map(arg_0 -> this.convertToDTO(arg_0)).collect(Collectors.toList());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body(dtos);
    }

    @GetMapping(value={"/templates/total"})
    public ResponseEntity<Map<String, Long>> getTotalTemplatesCount() {
        UserPrincipal currentUser = this.getCurrentUser();
        if (currentUser == null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
        }
        Map result = this.reportService.getTotalTemplatesCount(currentUser);
        return ResponseEntity.ok((Object)result);
    }
}

