/*
 * Decompiled with CFR 0.152.
 */
package Tech_Nagendra.Certificates_genration.Controller;

import Tech_Nagendra.Certificates_genration.Dto.TemplateDto;
import Tech_Nagendra.Certificates_genration.Service.ProfileService;
import Tech_Nagendra.Certificates_genration.Service.TemplateService;
import Tech_Nagendra.Certificates_genration.Utility.JwtUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/templates"})
@CrossOrigin(origins={"http://localhost:8081"}, allowCredentials="true")
public class TemplateController {
    private final TemplateService templateService;
    private final JwtUtil jwtUtil;
    private final ProfileService profileService;
    @Value(value="${certificate.template.path:${user.dir}/templates/}")
    private String templateBasePath;
    @Value(value="${server.port:8086}")
    private String serverPort;

    public TemplateController(TemplateService templateService, JwtUtil jwtUtil, ProfileService profileService) {
        this.templateService = templateService;
        this.jwtUtil = jwtUtil;
        this.profileService = profileService;
    }

    private String extractToken(HttpServletRequest request) {
        String authHeader = request.getHeader("Authorization");
        if (authHeader == null || !authHeader.startsWith("Bearer ")) {
            throw new IllegalArgumentException("Missing or invalid Authorization header");
        }
        return authHeader.substring(7).trim();
    }

    @PostMapping(consumes={"multipart/form-data"})
    public ResponseEntity<?> uploadTemplate(@RequestParam(value="templateName") String templateName, @RequestParam(value="imageType") Integer imageType, @RequestParam(value="createdBy") Long createdBy, @RequestPart(value="jrxml") MultipartFile[] jrxmlFiles, @RequestPart(value="images", required=false) MultipartFile[] images, HttpServletRequest request) {
        try {
            String token = this.extractToken(request);
            String username = this.jwtUtil.extractUsername(token);
            this.jwtUtil.validateToken(token, username);
            Long uploaderId = this.jwtUtil.extractUserId(token);
            String uploaderRole = this.jwtUtil.extractRole(token);
            if (uploaderId == null) {
                return ResponseEntity.status((int)401).body((Object)"Invalid token: user not found");
            }
            TemplateDto saved = this.templateService.saveTemplate(createdBy, templateName, imageType, jrxmlFiles, images);
            return ResponseEntity.ok((Object)saved);
        }
        catch (IllegalArgumentException e) {
            return ResponseEntity.status((int)401).body((Object)e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.badRequest().body((Object)("Failed to upload template: " + e.getMessage()));
        }
    }

    @GetMapping
    public ResponseEntity<?> getAllTemplates(HttpServletRequest request) {
        try {
            String token = this.extractToken(request);
            Long userId = this.jwtUtil.extractUserId(token);
            String role = this.jwtUtil.extractRole(token);
            if (userId == null) {
                return ResponseEntity.status((int)401).body((Object)"Invalid token");
            }
            List templates = this.templateService.getAllTemplates(userId, role);
            if (templates.isEmpty()) {
                return ResponseEntity.noContent().build();
            }
            return ResponseEntity.ok((Object)templates);
        }
        catch (IllegalArgumentException e) {
            return ResponseEntity.status((int)401).body((Object)e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status((int)500).body((Object)("Error fetching templates: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<?> getTemplateById(@PathVariable Long id, HttpServletRequest request) {
        try {
            String token = this.extractToken(request);
            Long userId = this.jwtUtil.extractUserId(token);
            String role = this.jwtUtil.extractRole(token);
            if (userId == null) {
                return ResponseEntity.status((int)401).body((Object)"Invalid token: user not found");
            }
            TemplateDto template = this.templateService.getTemplateByIdForUser(id, userId, role);
            if (template == null) {
                return ResponseEntity.status((int)404).body((Object)"Template not found");
            }
            return ResponseEntity.ok((Object)template);
        }
        catch (IllegalArgumentException e) {
            return ResponseEntity.status((int)401).body((Object)e.getMessage());
        }
        catch (RuntimeException e) {
            return ResponseEntity.status((int)403).body((Object)e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status((int)500).body((Object)("Error fetching template: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/{templateId}/images"})
    public ResponseEntity<?> getTemplateImages(@PathVariable Long templateId, HttpServletRequest request) {
        try {
            String token = this.extractToken(request);
            Long userId = this.jwtUtil.extractUserId(token);
            String role = this.jwtUtil.extractRole(token);
            if (userId == null) {
                return ResponseEntity.status((int)401).body((Object)"Invalid token");
            }
            TemplateDto template = this.templateService.getTemplateByIdForUser(templateId, userId, role);
            if (template == null) {
                return ResponseEntity.status((int)404).body((Object)"Template not found");
            }
            File folder = new File(this.templateBasePath + File.separator + template.getTemplateName());
            if (!folder.exists() || !folder.isDirectory()) {
                return ResponseEntity.ok(Collections.emptyList());
            }
            ArrayList<CallSite> imageUrls = new ArrayList<CallSite>();
            for (File file : Objects.requireNonNull(folder.listFiles())) {
                String name;
                if (!file.isFile() || !(name = file.getName().toLowerCase()).endsWith(".png") && !name.endsWith(".jpg") && !name.endsWith(".jpeg")) continue;
                String url = "http://localhost:" + this.serverPort + "/templates/images/" + template.getTemplateName() + "/" + file.getName();
                imageUrls.add((CallSite)((Object)url));
            }
            return ResponseEntity.ok(imageUrls);
        }
        catch (IllegalArgumentException e) {
            return ResponseEntity.status((int)401).body((Object)e.getMessage());
        }
        catch (RuntimeException e) {
            return ResponseEntity.status((int)403).body((Object)e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status((int)500).body((Object)("Error fetching template images: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/count"})
    public ResponseEntity<?> getTotalTemplates(HttpServletRequest request) {
        try {
            String token = this.extractToken(request);
            Long userId = this.jwtUtil.extractUserId(token);
            String role = this.jwtUtil.extractRole(token);
            if (userId == null) {
                return ResponseEntity.status((int)401).body((Object)"Invalid token: user not found");
            }
            Long count = this.templateService.getTotalTemplates(userId, role);
            return ResponseEntity.ok((Object)count);
        }
        catch (IllegalArgumentException e) {
            return ResponseEntity.status((int)401).body((Object)e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status((int)500).body((Object)("Failed to fetch template count: " + e.getMessage()));
        }
    }
}

