/*
 * Decompiled with CFR 0.152.
 */
package Tech_Nagendra.Certificates_genration.Entity;

import Tech_Nagendra.Certificates_genration.Entity.Template;
import Tech_Nagendra.Certificates_genration.Entity.UserProfile;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@EntityListeners(value={AuditingEntityListener.class})
@Table(name="reports")
public class Report {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    private String sid;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_profile_id")
    @JsonBackReference
    private UserProfile userProfile;
    @CreatedBy
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="generated_by")
    @JsonBackReference
    private UserProfile generatedBy;
    @CreatedDate
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="generated_on")
    private Date generatedOn;
    @Column(name="job_role")
    private String jobrole;
    @Column(name="candidate_name")
    private String candidateName;
    private String level;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="template_id")
    @JsonIgnore
    private Template template;
    @Column(name="training_partner")
    private String trainingPartner;
    @Column(name="batch_id")
    private String batchId;
    private String grade;
    private String templateName;
    @LastModifiedBy
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="modified_by")
    @JsonBackReference
    private UserProfile modifiedBy;
    @LastModifiedDate
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="modified_on")
    private Date modifiedOn;
    @Column(name="certificates_count")
    private Long certificatesCount;
    private String status;
    private Boolean active;

    @PrePersist
    protected void onCreate() {
        if (this.active == null) {
            this.active = true;
        }
        if (this.status == null) {
            this.status = "GENERATED";
        }
    }

    public String toString() {
        return "Report{id=" + this.id + ", sid='" + this.sid + "', userProfileId=" + (this.userProfile != null ? this.userProfile.getId() : null) + ", generatedById=" + (this.generatedBy != null ? this.generatedBy.getId() : null) + ", generatedOn=" + this.generatedOn + ", jobrole='" + this.jobrole + "', courseName='" + this.candidateName + "', level='" + this.level + "', templateId=" + (this.template != null ? this.template.getId() : null) + ", trainingPartner='" + this.trainingPartner + "', batchId='" + this.batchId + "', grade='" + this.grade + "', templateName='" + this.templateName + "', modifiedById=" + (this.modifiedBy != null ? this.modifiedBy.getId() : null) + ", modifiedOn=" + this.modifiedOn + ", certificatesCount=" + this.certificatesCount + ", status='" + this.status + "', active=" + this.active + "}";
    }

    public Long getId() {
        return this.id;
    }

    public String getSid() {
        return this.sid;
    }

    public UserProfile getUserProfile() {
        return this.userProfile;
    }

    public UserProfile getGeneratedBy() {
        return this.generatedBy;
    }

    public Date getGeneratedOn() {
        return this.generatedOn;
    }

    public String getJobrole() {
        return this.jobrole;
    }

    public String getCandidateName() {
        return this.candidateName;
    }

    public String getLevel() {
        return this.level;
    }

    public Template getTemplate() {
        return this.template;
    }

    public String getTrainingPartner() {
        return this.trainingPartner;
    }

    public String getBatchId() {
        return this.batchId;
    }

    public String getGrade() {
        return this.grade;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public UserProfile getModifiedBy() {
        return this.modifiedBy;
    }

    public Date getModifiedOn() {
        return this.modifiedOn;
    }

    public Long getCertificatesCount() {
        return this.certificatesCount;
    }

    public String getStatus() {
        return this.status;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public void setUserProfile(UserProfile userProfile) {
        this.userProfile = userProfile;
    }

    public void setGeneratedBy(UserProfile generatedBy) {
        this.generatedBy = generatedBy;
    }

    public void setGeneratedOn(Date generatedOn) {
        this.generatedOn = generatedOn;
    }

    public void setJobrole(String jobrole) {
        this.jobrole = jobrole;
    }

    public void setCandidateName(String candidateName) {
        this.candidateName = candidateName;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    @JsonIgnore
    public void setTemplate(Template template) {
        this.template = template;
    }

    public void setTrainingPartner(String trainingPartner) {
        this.trainingPartner = trainingPartner;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    public void setGrade(String grade) {
        this.grade = grade;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public void setModifiedBy(UserProfile modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public void setModifiedOn(Date modifiedOn) {
        this.modifiedOn = modifiedOn;
    }

    public void setCertificatesCount(Long certificatesCount) {
        this.certificatesCount = certificatesCount;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Report)) {
            return false;
        }
        Report other = (Report)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$certificatesCount = this.getCertificatesCount();
        Long other$certificatesCount = other.getCertificatesCount();
        if (this$certificatesCount == null ? other$certificatesCount != null : !((Object)this$certificatesCount).equals(other$certificatesCount)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        String this$sid = this.getSid();
        String other$sid = other.getSid();
        if (this$sid == null ? other$sid != null : !this$sid.equals(other$sid)) {
            return false;
        }
        UserProfile this$userProfile = this.getUserProfile();
        UserProfile other$userProfile = other.getUserProfile();
        if (this$userProfile == null ? other$userProfile != null : !this$userProfile.equals(other$userProfile)) {
            return false;
        }
        UserProfile this$generatedBy = this.getGeneratedBy();
        UserProfile other$generatedBy = other.getGeneratedBy();
        if (this$generatedBy == null ? other$generatedBy != null : !this$generatedBy.equals(other$generatedBy)) {
            return false;
        }
        Date this$generatedOn = this.getGeneratedOn();
        Date other$generatedOn = other.getGeneratedOn();
        if (this$generatedOn == null ? other$generatedOn != null : !((Object)this$generatedOn).equals(other$generatedOn)) {
            return false;
        }
        String this$jobrole = this.getJobrole();
        String other$jobrole = other.getJobrole();
        if (this$jobrole == null ? other$jobrole != null : !this$jobrole.equals(other$jobrole)) {
            return false;
        }
        String this$candidateName = this.getCandidateName();
        String other$candidateName = other.getCandidateName();
        if (this$candidateName == null ? other$candidateName != null : !this$candidateName.equals(other$candidateName)) {
            return false;
        }
        String this$level = this.getLevel();
        String other$level = other.getLevel();
        if (this$level == null ? other$level != null : !this$level.equals(other$level)) {
            return false;
        }
        Template this$template = this.getTemplate();
        Template other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !this$template.equals(other$template)) {
            return false;
        }
        String this$trainingPartner = this.getTrainingPartner();
        String other$trainingPartner = other.getTrainingPartner();
        if (this$trainingPartner == null ? other$trainingPartner != null : !this$trainingPartner.equals(other$trainingPartner)) {
            return false;
        }
        String this$batchId = this.getBatchId();
        String other$batchId = other.getBatchId();
        if (this$batchId == null ? other$batchId != null : !this$batchId.equals(other$batchId)) {
            return false;
        }
        String this$grade = this.getGrade();
        String other$grade = other.getGrade();
        if (this$grade == null ? other$grade != null : !this$grade.equals(other$grade)) {
            return false;
        }
        String this$templateName = this.getTemplateName();
        String other$templateName = other.getTemplateName();
        if (this$templateName == null ? other$templateName != null : !this$templateName.equals(other$templateName)) {
            return false;
        }
        UserProfile this$modifiedBy = this.getModifiedBy();
        UserProfile other$modifiedBy = other.getModifiedBy();
        if (this$modifiedBy == null ? other$modifiedBy != null : !this$modifiedBy.equals(other$modifiedBy)) {
            return false;
        }
        Date this$modifiedOn = this.getModifiedOn();
        Date other$modifiedOn = other.getModifiedOn();
        if (this$modifiedOn == null ? other$modifiedOn != null : !((Object)this$modifiedOn).equals(other$modifiedOn)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !this$status.equals(other$status));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Report;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $certificatesCount = this.getCertificatesCount();
        result = result * 59 + ($certificatesCount == null ? 43 : ((Object)$certificatesCount).hashCode());
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        String $sid = this.getSid();
        result = result * 59 + ($sid == null ? 43 : $sid.hashCode());
        UserProfile $userProfile = this.getUserProfile();
        result = result * 59 + ($userProfile == null ? 43 : $userProfile.hashCode());
        UserProfile $generatedBy = this.getGeneratedBy();
        result = result * 59 + ($generatedBy == null ? 43 : $generatedBy.hashCode());
        Date $generatedOn = this.getGeneratedOn();
        result = result * 59 + ($generatedOn == null ? 43 : ((Object)$generatedOn).hashCode());
        String $jobrole = this.getJobrole();
        result = result * 59 + ($jobrole == null ? 43 : $jobrole.hashCode());
        String $candidateName = this.getCandidateName();
        result = result * 59 + ($candidateName == null ? 43 : $candidateName.hashCode());
        String $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : $level.hashCode());
        Template $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : $template.hashCode());
        String $trainingPartner = this.getTrainingPartner();
        result = result * 59 + ($trainingPartner == null ? 43 : $trainingPartner.hashCode());
        String $batchId = this.getBatchId();
        result = result * 59 + ($batchId == null ? 43 : $batchId.hashCode());
        String $grade = this.getGrade();
        result = result * 59 + ($grade == null ? 43 : $grade.hashCode());
        String $templateName = this.getTemplateName();
        result = result * 59 + ($templateName == null ? 43 : $templateName.hashCode());
        UserProfile $modifiedBy = this.getModifiedBy();
        result = result * 59 + ($modifiedBy == null ? 43 : $modifiedBy.hashCode());
        Date $modifiedOn = this.getModifiedOn();
        result = result * 59 + ($modifiedOn == null ? 43 : ((Object)$modifiedOn).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        return result;
    }
}

