/*
 * Decompiled with CFR 0.152.
 */
package Tech_Nagendra.Certificates_genration.Entity;

import Tech_Nagendra.Certificates_genration.Entity.TemplateImage;
import Tech_Nagendra.Certificates_genration.Entity.UserProfile;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@EntityListeners(value={AuditingEntityListener.class})
@Table(name="templates")
public class Template {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="template_name")
    private String templateName;
    @Column(name="image_type")
    private Integer imageType;
    @CreatedDate
    @Column(name="created_at", updatable=false)
    private LocalDateTime createdAt;
    @Column(name="jrxml_path")
    private String jrxmlPath;
    @Column(name="template_folder")
    private String templateFolder;
    @LastModifiedDate
    @Column(name="modified_at")
    private LocalDateTime modifiedAt;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="created_by")
    @JsonBackReference
    private UserProfile createdBy;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="modified_by")
    @JsonBackReference
    private UserProfile modifiedBy;
    @OneToMany(mappedBy="template", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JsonIgnore
    private List<TemplateImage> images;

    public String toString() {
        return "Template{id=" + this.id + ", templateName='" + this.templateName + "', imageType=" + this.imageType + ", createdAt=" + this.createdAt + ", jrxmlPath='" + this.jrxmlPath + "', templateFolder='" + this.templateFolder + "', modifiedAt=" + this.modifiedAt + ", createdById=" + (this.createdBy != null ? this.createdBy.getId() : null) + ", modifiedById=" + (this.modifiedBy != null ? this.modifiedBy.getId() : null) + "}";
    }

    public Long getId() {
        return this.id;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public Integer getImageType() {
        return this.imageType;
    }

    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    public String getJrxmlPath() {
        return this.jrxmlPath;
    }

    public String getTemplateFolder() {
        return this.templateFolder;
    }

    public LocalDateTime getModifiedAt() {
        return this.modifiedAt;
    }

    public UserProfile getCreatedBy() {
        return this.createdBy;
    }

    public UserProfile getModifiedBy() {
        return this.modifiedBy;
    }

    public List<TemplateImage> getImages() {
        return this.images;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public void setImageType(Integer imageType) {
        this.imageType = imageType;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public void setJrxmlPath(String jrxmlPath) {
        this.jrxmlPath = jrxmlPath;
    }

    public void setTemplateFolder(String templateFolder) {
        this.templateFolder = templateFolder;
    }

    public void setModifiedAt(LocalDateTime modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    public void setCreatedBy(UserProfile createdBy) {
        this.createdBy = createdBy;
    }

    public void setModifiedBy(UserProfile modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    @JsonIgnore
    public void setImages(List<TemplateImage> images) {
        this.images = images;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Template)) {
            return false;
        }
        Template other = (Template)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$imageType = this.getImageType();
        Integer other$imageType = other.getImageType();
        if (this$imageType == null ? other$imageType != null : !((Object)this$imageType).equals(other$imageType)) {
            return false;
        }
        String this$templateName = this.getTemplateName();
        String other$templateName = other.getTemplateName();
        if (this$templateName == null ? other$templateName != null : !this$templateName.equals(other$templateName)) {
            return false;
        }
        LocalDateTime this$createdAt = this.getCreatedAt();
        LocalDateTime other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        String this$jrxmlPath = this.getJrxmlPath();
        String other$jrxmlPath = other.getJrxmlPath();
        if (this$jrxmlPath == null ? other$jrxmlPath != null : !this$jrxmlPath.equals(other$jrxmlPath)) {
            return false;
        }
        String this$templateFolder = this.getTemplateFolder();
        String other$templateFolder = other.getTemplateFolder();
        if (this$templateFolder == null ? other$templateFolder != null : !this$templateFolder.equals(other$templateFolder)) {
            return false;
        }
        LocalDateTime this$modifiedAt = this.getModifiedAt();
        LocalDateTime other$modifiedAt = other.getModifiedAt();
        if (this$modifiedAt == null ? other$modifiedAt != null : !((Object)this$modifiedAt).equals(other$modifiedAt)) {
            return false;
        }
        UserProfile this$createdBy = this.getCreatedBy();
        UserProfile other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        UserProfile this$modifiedBy = this.getModifiedBy();
        UserProfile other$modifiedBy = other.getModifiedBy();
        if (this$modifiedBy == null ? other$modifiedBy != null : !this$modifiedBy.equals(other$modifiedBy)) {
            return false;
        }
        List this$images = this.getImages();
        List other$images = other.getImages();
        return !(this$images == null ? other$images != null : !((Object)this$images).equals(other$images));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Template;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $imageType = this.getImageType();
        result = result * 59 + ($imageType == null ? 43 : ((Object)$imageType).hashCode());
        String $templateName = this.getTemplateName();
        result = result * 59 + ($templateName == null ? 43 : $templateName.hashCode());
        LocalDateTime $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        String $jrxmlPath = this.getJrxmlPath();
        result = result * 59 + ($jrxmlPath == null ? 43 : $jrxmlPath.hashCode());
        String $templateFolder = this.getTemplateFolder();
        result = result * 59 + ($templateFolder == null ? 43 : $templateFolder.hashCode());
        LocalDateTime $modifiedAt = this.getModifiedAt();
        result = result * 59 + ($modifiedAt == null ? 43 : ((Object)$modifiedAt).hashCode());
        UserProfile $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        UserProfile $modifiedBy = this.getModifiedBy();
        result = result * 59 + ($modifiedBy == null ? 43 : $modifiedBy.hashCode());
        List $images = this.getImages();
        result = result * 59 + ($images == null ? 43 : ((Object)$images).hashCode());
        return result;
    }
}

