/*
 * Decompiled with CFR 0.152.
 */
package Tech_Nagendra.Certificates_genration.Entity;

import Tech_Nagendra.Certificates_genration.Entity.Report;
import Tech_Nagendra.Certificates_genration.Entity.Template;
import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@EntityListeners(value={AuditingEntityListener.class})
@Table(name="user_profile")
public class UserProfile {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(unique=true, nullable=false)
    private String username;
    @Column(name="rollid")
    private Long rollid;
    private String name;
    @Column(unique=true, nullable=false)
    private String email;
    @JsonIgnore
    private String password;
    private String role;
    @CreatedDate
    @Column(updatable=false)
    private LocalDateTime createdAt;
    @CreatedBy
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="created_by")
    @JsonIgnore
    private UserProfile createdBy;
    @Column(name="login_token")
    private String loginToken;
    @LastModifiedDate
    private LocalDateTime modifiedAt;
    @LastModifiedBy
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="modified_by")
    @JsonIgnore
    private UserProfile modifiedBy;
    @OneToMany(mappedBy="createdBy", fetch=FetchType.LAZY)
    @JsonIgnore
    private List<Template> createdTemplates;
    @OneToMany(mappedBy="modifiedBy", fetch=FetchType.LAZY)
    @JsonIgnore
    private List<Template> modifiedTemplates;
    @OneToMany(mappedBy="userProfile", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JsonIgnore
    private List<Report> reports;
    @OneToMany(mappedBy="generatedBy", fetch=FetchType.LAZY)
    @JsonIgnore
    private List<Report> generatedReports;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserProfile)) {
            return false;
        }
        UserProfile that = (UserProfile)o;
        return Objects.equals(this.getId(), that.getId());
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    public String toString() {
        return "UserProfile{id=" + this.id + ", username='" + this.username + "', rollid=" + this.rollid + ", name='" + this.name + "', email='" + this.email + "', role='" + this.role + "', createdAt=" + this.createdAt + ", createdBy=" + (this.createdBy != null ? this.createdBy.getId() : null) + ", modifiedAt=" + this.modifiedAt + ", modifiedBy=" + (this.modifiedBy != null ? this.modifiedBy.getId() : null) + "}";
    }

    public Long getId() {
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    public Long getRollid() {
        return this.rollid;
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public String getPassword() {
        return this.password;
    }

    public String getRole() {
        return this.role;
    }

    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    public UserProfile getCreatedBy() {
        return this.createdBy;
    }

    public String getLoginToken() {
        return this.loginToken;
    }

    public LocalDateTime getModifiedAt() {
        return this.modifiedAt;
    }

    public UserProfile getModifiedBy() {
        return this.modifiedBy;
    }

    public List<Template> getCreatedTemplates() {
        return this.createdTemplates;
    }

    public List<Template> getModifiedTemplates() {
        return this.modifiedTemplates;
    }

    public List<Report> getReports() {
        return this.reports;
    }

    public List<Report> getGeneratedReports() {
        return this.generatedReports;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setRollid(Long rollid) {
        this.rollid = rollid;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @JsonIgnore
    public void setPassword(String password) {
        this.password = password;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @JsonIgnore
    public void setCreatedBy(UserProfile createdBy) {
        this.createdBy = createdBy;
    }

    public void setLoginToken(String loginToken) {
        this.loginToken = loginToken;
    }

    public void setModifiedAt(LocalDateTime modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    @JsonIgnore
    public void setModifiedBy(UserProfile modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    @JsonIgnore
    public void setCreatedTemplates(List<Template> createdTemplates) {
        this.createdTemplates = createdTemplates;
    }

    @JsonIgnore
    public void setModifiedTemplates(List<Template> modifiedTemplates) {
        this.modifiedTemplates = modifiedTemplates;
    }

    @JsonIgnore
    public void setReports(List<Report> reports) {
        this.reports = reports;
    }

    @JsonIgnore
    public void setGeneratedReports(List<Report> generatedReports) {
        this.generatedReports = generatedReports;
    }
}

