/*
 * Decompiled with CFR 0.152.
 */
package Tech_Nagendra.Certificates_genration.JWTfilter;

import Tech_Nagendra.Certificates_genration.Security.UserPrincipal;
import Tech_Nagendra.Certificates_genration.Utility.JwtUtil;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureException;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class JwtFilter
extends OncePerRequestFilter {
    @Autowired
    private JwtUtil jwtUtil;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String authHeader = request.getHeader("Authorization");
        String jwt = null;
        System.out.println(">> Incoming request: " + request.getMethod() + " " + request.getRequestURI());
        System.out.println("   Authorization header: " + (authHeader == null ? "null" : authHeader));
        if (authHeader != null && authHeader.startsWith("Bearer ")) {
            jwt = authHeader.substring(7).trim();
            jwt = jwt.replaceAll("[<>]", "");
        }
        if (jwt != null && SecurityContextHolder.getContext().getAuthentication() == null) {
            try {
                ArrayList<SimpleGrantedAuthority> authorities;
                jwt = this.jwtUtil.cleanToken(jwt);
                System.out.println("   Cleaned token (first 40 chars): " + (String)(jwt.length() > 40 ? jwt.substring(0, 40) + "..." : jwt));
                Long userId = this.jwtUtil.extractUserId(jwt);
                String username = this.jwtUtil.extractUsername(jwt);
                String role = this.jwtUtil.extractRole(jwt);
                System.out.println("   Parsed claims -> userId: " + userId + ", username: " + username + ", role: " + role);
                if (userId != null && username != null) {
                    authorities = new ArrayList<SimpleGrantedAuthority>();
                    if (role != null && !role.isEmpty()) {
                        for (String r : role.split(",")) {
                            authorities.add(new SimpleGrantedAuthority("ROLE_" + r.trim().toUpperCase()));
                        }
                    }
                } else {
                    this.sendError(response, 401, "Missing required JWT claims (userId/username)");
                    return;
                }
                UserPrincipal principal = new UserPrincipal(userId, username, "", role, authorities);
                UsernamePasswordAuthenticationToken authToken = new UsernamePasswordAuthenticationToken((Object)principal, null, authorities);
                SecurityContextHolder.getContext().setAuthentication((Authentication)authToken);
            }
            catch (ExpiredJwtException e) {
                this.sendError(response, 401, "JWT expired. Please login again.");
                return;
            }
            catch (MalformedJwtException e) {
                this.sendError(response, 401, "Malformed JWT token");
                return;
            }
            catch (SignatureException e) {
                this.sendError(response, 401, "Invalid JWT signature");
                return;
            }
            catch (IllegalArgumentException e) {
                this.sendError(response, 401, "JWT token is missing or empty");
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.sendError(response, 401, "Invalid JWT token");
                return;
            }
        } else if (jwt == null) {
            System.out.println("   No JWT token provided in Authorization header.");
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void sendError(HttpServletResponse response, int status, String message) throws IOException {
        response.setContentType("application/json");
        response.setStatus(status);
        response.getWriter().write(String.format("{\"error\":\"%s\"}", message));
    }

    protected boolean shouldNotFilter(HttpServletRequest request) {
        String path = request.getRequestURI();
        return path.startsWith("/public") || path.startsWith("/login") || path.startsWith("/register") || path.startsWith("/auth") || "OPTIONS".equalsIgnoreCase(request.getMethod());
    }
}

