/*
 * Decompiled with CFR 0.152.
 */
package Tech_Nagendra.Certificates_genration.Repository;

import Tech_Nagendra.Certificates_genration.Entity.Report;
import Tech_Nagendra.Certificates_genration.Entity.UserProfile;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ReportRepository
extends JpaRepository<Report, Long> {
    public long countByGeneratedBy_Id(Long var1);

    public long countByGeneratedBy_IdAndGeneratedOnBetween(Long var1, Date var2, Date var3);

    public long countByGeneratedBy_IdAndStatus(Long var1, String var2);

    public Long countByGeneratedBy(UserProfile var1);

    public Long countByGeneratedByAndGeneratedOnBetween(UserProfile var1, Date var2, Date var3);

    public Long countByGeneratedOnBetween(Date var1, Date var2);

    public Long countByStatus(String var1);

    public List<Report> findByGeneratedBy_Id(Long var1);

    @Query(value="SELECT r FROM Report r WHERE r.generatedOn BETWEEN :startDate AND :endDate ORDER BY r.generatedOn DESC")
    public List<Report> findByGeneratedOnBetween(@Param(value="startDate") Date var1, @Param(value="endDate") Date var2);

    @Query(value="SELECT r FROM Report r WHERE r.generatedBy.id = :userId AND r.generatedOn BETWEEN :startDate AND :endDate ORDER BY r.generatedOn DESC")
    public List<Report> findByGeneratedBy_IdAndGeneratedOnBetween(@Param(value="userId") Long var1, @Param(value="startDate") Date var2, @Param(value="endDate") Date var3);

    public Optional<Report> findTopByGeneratedBy_IdOrderByGeneratedOnDesc(Long var1);

    public Optional<Report> findTopByGeneratedBy_IdAndStatusOrderByGeneratedOnDesc(Long var1, String var2);

    public List<Report> findByGeneratedBy(UserProfile var1);

    public List<Report> findBySid(String var1);

    public Optional<Report> findBySidAndTemplateName(String var1, String var2);

    @Query(value="SELECT r FROM Report r WHERE r.userProfile.id = :userId AND r.template.id = :templateId")
    public List<Report> findByUserProfile_IdAndTemplateId(@Param(value="userId") Long var1, @Param(value="templateId") Long var2);

    @Query(value="SELECT r FROM Report r WHERE r.sid = :sid AND r.template.id = :templateId")
    public List<Report> findAllBySidAndTemplateId(@Param(value="sid") String var1, @Param(value="templateId") Long var2);

    @Query(value="SELECT r FROM Report r WHERE r.sid = :sid AND r.template.id = :templateId")
    public List<Report> findAllBySidAndTemplateID(@Param(value="sid") String var1, @Param(value="templateId") Long var2);

    @Query(value="SELECT r FROM Report r WHERE r.userProfile.id = :userId AND r.template.id = :templateId")
    public List<Report> findAllByUserProfile_IdAndTemplateId(@Param(value="userId") Long var1, @Param(value="templateId") Long var2);

    @Query(value="SELECT COUNT(r) FROM Report r WHERE MONTH(r.generatedOn) = MONTH(CURRENT_DATE) AND YEAR(r.generatedOn) = YEAR(CURRENT_DATE)")
    public Long countCertificatesThisMonth();

    @Query(value="SELECT COUNT(r) FROM Report r WHERE r.generatedBy.id = :userId AND MONTH(r.generatedOn) = MONTH(CURRENT_DATE) AND YEAR(r.generatedOn) = YEAR(CURRENT_DATE)")
    public Long countCertificatesThisMonthByUser(Long var1);

    @Query(value="SELECT FUNCTION('YEAR', r.generatedOn), FUNCTION('MONTH', r.generatedOn), COUNT(r) FROM Report r GROUP BY FUNCTION('YEAR', r.generatedOn), FUNCTION('MONTH', r.generatedOn) ORDER BY FUNCTION('YEAR', r.generatedOn), FUNCTION('MONTH', r.generatedOn)")
    public List<Object[]> getMonthlyCertificateStats();

    @Query(value="SELECT r FROM Report r WHERE r.template.id = :templateId")
    public List<Report> findByTemplateId(@Param(value="templateId") Long var1);

    @Query(value="SELECT COUNT(r) FROM Report r WHERE r.template.id = :templateId")
    public Long countByTemplateId(@Param(value="templateId") Long var1);

    @Query(value="SELECT r FROM Report r JOIN FETCH r.generatedBy WHERE r.generatedBy.id = :userId")
    public List<Report> findByGeneratedBy_IdWithUser(@Param(value="userId") Long var1);
}

