/*
 * Decompiled with CFR 0.152.
 */
package Tech_Nagendra.Certificates_genration.Security;

import Tech_Nagendra.Certificates_genration.Entity.UserProfile;
import Tech_Nagendra.Certificates_genration.Repository.ProfileRepository;
import Tech_Nagendra.Certificates_genration.Security.UserPrincipal;
import Tech_Nagendra.Certificates_genration.Utility.JwtUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.AuditorAware;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component(value="auditorProvider")
public class AuditorAwareImpl
implements AuditorAware<UserProfile> {
    @Autowired
    private JwtUtil jwtUtil;
    @Autowired
    private ProfileRepository profileRepository;

    public Optional<UserProfile> getCurrentAuditor() {
        try {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            Long userId = null;
            if (authentication != null && authentication.isAuthenticated()) {
                Object principal = authentication.getPrincipal();
                if (principal instanceof UserPrincipal) {
                    UserPrincipal userPrincipal = (UserPrincipal)principal;
                    userId = userPrincipal.getId();
                }
                if (userId == null) {
                    HttpServletRequest request;
                    String header;
                    ServletRequestAttributes attributes;
                    String token = null;
                    if (authentication.getCredentials() != null) {
                        token = authentication.getCredentials().toString();
                    }
                    if (token == null && (attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes()) != null && (header = (request = attributes.getRequest()).getHeader("Authorization")) != null && header.startsWith("Bearer ")) {
                        token = header.substring(7);
                    }
                    if (token != null && !token.isEmpty()) {
                        userId = this.jwtUtil.extractUserId(token);
                    }
                }
            }
            if (userId != null) {
                return this.profileRepository.findById(userId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Optional.empty();
    }
}

