/*
 * Decompiled with CFR 0.152.
 */
package Tech_Nagendra.Certificates_genration.Service;

import Tech_Nagendra.Certificates_genration.Entity.CandidateDTO;
import Tech_Nagendra.Certificates_genration.Entity.Template;
import Tech_Nagendra.Certificates_genration.Repository.CandidateRepository;
import Tech_Nagendra.Certificates_genration.Repository.TemplateRepository;
import Tech_Nagendra.Certificates_genration.Service.CandidateService;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.springframework.stereotype.Service;

@Service
public class CandidateService {
    private final CandidateRepository candidateRepository;
    private final TemplateRepository templateRepository;

    public CandidateService(CandidateRepository candidateRepository, TemplateRepository templateRepository) {
        this.candidateRepository = candidateRepository;
        this.templateRepository = templateRepository;
    }

    public void saveCandidatesFromExcel(File excelFile, Long templateId) throws Exception {
        Template template = (Template)this.templateRepository.findById((Object)templateId).orElseThrow(() -> new RuntimeException("Template not found"));
        try (FileInputStream is = new FileInputStream(excelFile);){
            Workbook workbook = WorkbookFactory.create((InputStream)is);
            Sheet sheet = workbook.getSheetAt(0);
            for (int i = 1; i <= sheet.getLastRowNum(); ++i) {
                Row row = sheet.getRow(i);
                if (row == null) continue;
                CandidateDTO candidate = new CandidateDTO();
                candidate.setSalutation(this.getCellValue(row, 0));
                candidate.setCandidateName(this.getCellValue(row, 1));
                candidate.setSid(this.getCellValue(row, 2));
                candidate.setJobRole(this.getCellValue(row, 3));
                candidate.setGuardianType(this.getCellValue(row, 4));
                candidate.setFatherORHusbandName(this.getCellValue(row, 5));
                candidate.setSectorSkillCouncil(this.getCellValue(row, 6));
                Cell dateCell = row.getCell(7, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
                String formattedDate = "";
                if (dateCell.getCellType() == CellType.NUMERIC && DateUtil.isCellDateFormatted((Cell)dateCell)) {
                    Date date = dateCell.getDateCellValue();
                    localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                    formattedDate = localDate.format(DateTimeFormatter.ofPattern("dd-MM-yyyy"));
                } else {
                    String rawDate = this.getCellValue(row, 7);
                    try {
                        localDate = LocalDate.parse(rawDate);
                        formattedDate = localDate.format(DateTimeFormatter.ofPattern("dd-MM-yyyy"));
                    }
                    catch (Exception e) {
                        formattedDate = rawDate;
                    }
                }
                candidate.setDateOfIssuance(formattedDate);
                candidate.setLevel(this.getCellValue(row, 8));
                candidate.setAadhaarNumber(this.getCellValue(row, 9));
                candidate.setSector(this.getCellValue(row, 10));
                candidate.setGrade(this.getCellValue(row, 11));
                candidate.setDateOfStart(this.getCellValue(row, 12));
                candidate.setDateOfEnd(this.getCellValue(row, 13));
                candidate.setMarks(this.getCellValue(row, 14));
                candidate.setMarks1(this.getCellValue(row, 15));
                candidate.setMarks2(this.getCellValue(row, 16));
                candidate.setMarks3(this.getCellValue(row, 17));
                candidate.setBatchId(this.getCellValue(row, 18));
                candidate.setTemplate(template);
                this.candidateRepository.save((Object)candidate);
            }
        }
    }

    private String getCellValue(Row row, int cellIndex) {
        Cell cell = row.getCell(cellIndex, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
        switch (1.$SwitchMap$org$apache$poi$ss$usermodel$CellType[cell.getCellType().ordinal()]) {
            case 1: {
                return cell.getStringCellValue();
            }
            case 2: {
                return String.valueOf((long)cell.getNumericCellValue());
            }
            case 3: {
                return String.valueOf(cell.getBooleanCellValue());
            }
        }
        return "";
    }
}

