/*
 * Decompiled with CFR 0.152.
 */
package Tech_Nagendra.Certificates_genration.Service;

import Tech_Nagendra.Certificates_genration.Entity.CandidateDTO;
import Tech_Nagendra.Certificates_genration.Entity.Report;
import Tech_Nagendra.Certificates_genration.Entity.Template;
import Tech_Nagendra.Certificates_genration.Repository.ProfileRepository;
import Tech_Nagendra.Certificates_genration.Repository.TemplateImageRepository;
import Tech_Nagendra.Certificates_genration.Repository.TemplateRepository;
import Tech_Nagendra.Certificates_genration.Security.UserPrincipal;
import Tech_Nagendra.Certificates_genration.Service.CertificateService;
import Tech_Nagendra.Certificates_genration.Service.ReportService;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimplePdfExporterConfiguration;
import net.sf.jasperreports.export.SimplePdfReportConfiguration;
import net.sf.jasperreports.export.type.PdfaConformanceEnum;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CertificateService {
    private static final Logger logger = LoggerFactory.getLogger(CertificateService.class);
    @Autowired
    private TemplateRepository templateRepository;
    @Autowired
    private TemplateImageRepository templateImageRepository;
    @Autowired
    private ProfileRepository profileRepository;
    @Autowired
    private ReportService reportService;
    @Value(value="${certificate.template.path:${user.dir}/templates/}")
    private String baseTemplateFolder;
    @Value(value="${custom.fonts.lib:lib}")
    private String libsFolder;
    @Value(value="${custom.fonts.dir:src/main/resources/fonts}")
    private String classpathFontsDir;
    private static volatile boolean fontsLoaded = false;

    private synchronized void loadAllFonts() {
        if (fontsLoaded) {
            return;
        }
        try {
            block23: {
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                try {
                    URL fontsDirUrl = this.getClass().getResource("/fonts/");
                    if (fontsDirUrl != null) {
                        File fontsDir;
                        try {
                            fontsDir = new File(fontsDirUrl.toURI());
                        }
                        catch (URISyntaxException e) {
                            fontsDir = new File(fontsDirUrl.getPath());
                        }
                        this.loadFontsFromFolder(fontsDir);
                        break block23;
                    }
                    File cf = new File(this.classpathFontsDir);
                    if (cf.exists() && cf.isDirectory()) {
                        this.loadFontsFromFolder(cf);
                    }
                }
                catch (Exception e) {
                    logger.info("Classpath fonts scan error: {}", (Object)e.getMessage());
                }
            }
            try {
                File externalFonts = new File(this.baseTemplateFolder);
                if (externalFonts.exists() && externalFonts.isDirectory()) {
                    this.loadFontsFromFolder(externalFonts);
                } else {
                    File fontsSub = new File(this.baseTemplateFolder, "fonts");
                    if (fontsSub.exists() && fontsSub.isDirectory()) {
                        this.loadFontsFromFolder(fontsSub);
                    }
                }
                File cfDir = new File(this.classpathFontsDir);
                if (cfDir.exists() && cfDir.isDirectory()) {
                    this.loadFontsFromFolder(cfDir);
                }
            }
            catch (Exception e) {
                logger.info("External fonts scan error: {}", (Object)e.getMessage());
            }
            try {
                File[] jars;
                File libDir = new File(this.libsFolder);
                if (libDir.exists() && libDir.isDirectory() && (jars = libDir.listFiles((d, name) -> name.toLowerCase().endsWith(".jar"))) != null) {
                    for (File j : jars) {
                        this.loadFontsFromJarFile(j);
                    }
                }
            }
            catch (Exception e) {
                logger.info("Libs folder scan error: {}", (Object)e.getMessage());
            }
            try {
                this.loadSystemFonts();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setupJasperReportsProperties();
            fontsLoaded = true;
            logger.info("Fonts loaded and JasperReports properties set.");
        }
        catch (Exception e) {
            logger.error("Error loading fonts", (Throwable)e);
            try {
                this.setupJasperReportsProperties();
            }
            catch (Exception exception) {
                // empty catch block
            }
            fontsLoaded = true;
        }
    }

    private void loadFontsFromFolder(File folder) {
        if (folder == null || !folder.exists() || !folder.isDirectory()) {
            return;
        }
        File[] files = folder.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            try {
                if (f.isDirectory()) {
                    this.loadFontsFromFolder(f);
                    continue;
                }
                String name = f.getName().toLowerCase();
                if (name.endsWith(".ttf") || name.endsWith(".otf")) {
                    try (InputStream is = Files.newInputStream(f.toPath(), new OpenOption[0]);){
                        Font font = Font.createFont(0, is);
                        GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font);
                        logger.info("Registered font file: {}", (Object)f.getAbsolutePath());
                    }
                    catch (Exception ex) {
                        logger.warn("Failed to register font file {} : {}", (Object)f.getName(), (Object)ex.getMessage());
                    }
                    continue;
                }
                if (!name.endsWith(".jar")) continue;
                this.loadFontsFromJarFile(f);
            }
            catch (Exception e) {
                logger.warn("Error processing {} : {}", (Object)f.getName(), (Object)e.getMessage());
            }
        }
    }

    private void loadFontsFromClasspathFolder(String resourceFolder) {
        block26: {
            try {
                URL url = this.getClass().getResource(resourceFolder);
                if (url == null) {
                    return;
                }
                String protocol = url.getProtocol();
                if ("jar".equals(protocol)) {
                    String jarPath;
                    String path = url.getPath();
                    if (path.startsWith("file:")) {
                        jarPath = path.substring(5, path.indexOf("!"));
                    } else {
                        int excl = path.indexOf("!");
                        jarPath = path.substring(0, excl);
                    }
                    try {
                        JarInputStream jis = new JarInputStream(new FileInputStream(jarPath));
                        block18: while (true) {
                            JarEntry entry;
                            while ((entry = jis.getNextJarEntry()) != null) {
                                String name = entry.getName().toLowerCase();
                                if (!name.startsWith("fonts/") || !name.endsWith(".ttf") && !name.endsWith(".otf")) continue;
                                try {
                                    InputStream is = this.getClass().getResourceAsStream("/" + entry.getName());
                                    try {
                                        if (is == null) continue block18;
                                        Font font = Font.createFont(0, is);
                                        GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font);
                                        logger.info("Registered classpath font: {}", (Object)entry.getName());
                                        continue block18;
                                    }
                                    finally {
                                        if (is != null) {
                                            is.close();
                                        }
                                        continue block18;
                                    }
                                }
                                catch (Exception ex) {
                                    logger.warn("Failed to register classpath font {} : {}", (Object)entry.getName(), (Object)ex.getMessage());
                                }
                            }
                            break block26;
                            {
                                continue block18;
                                break;
                            }
                            break;
                        }
                        finally {
                            jis.close();
                        }
                    }
                    catch (Exception e) {
                        logger.warn("Failed scanning jar for fonts: {}", (Object)e.getMessage());
                    }
                    break block26;
                }
                if ("file".equals(protocol)) {
                    try {
                        File folder = new File(url.toURI());
                        this.loadFontsFromFolder(folder);
                    }
                    catch (URISyntaxException e) {
                        logger.warn("Invalid URI for classpath fonts folder: {}", (Object)e.getMessage());
                    }
                }
            }
            catch (Exception e) {
                logger.warn("Could not load fonts from classpath folder {} : {}", (Object)resourceFolder, (Object)e.getMessage());
            }
        }
    }

    private void loadFontsFromJarFile(File jarFile) {
        block23: {
            if (jarFile == null || !jarFile.exists()) {
                return;
            }
            try (FileInputStream fis = new FileInputStream(jarFile);){
                JarInputStream jis = new JarInputStream(fis);
                block19: while (true) {
                    JarEntry entry;
                    while ((entry = jis.getNextJarEntry()) != null) {
                        int read;
                        String name = entry.getName().toLowerCase();
                        if (!name.endsWith(".ttf") && !name.endsWith(".otf")) continue;
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        byte[] buffer = new byte[4096];
                        while ((read = jis.read(buffer)) != -1) {
                            baos.write(buffer, 0, read);
                        }
                        try {
                            ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
                            try {
                                Font font = Font.createFont(0, is);
                                GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font);
                                logger.info("Registered font from jar {} -> {}", (Object)jarFile.getName(), (Object)name);
                                continue block19;
                            }
                            finally {
                                ((InputStream)is).close();
                                continue block19;
                            }
                        }
                        catch (Exception ex) {
                            logger.warn("Failed to create font from jar entry {} : {}", (Object)name, (Object)ex.getMessage());
                        }
                    }
                    break block23;
                    {
                        continue block19;
                        break;
                    }
                    break;
                }
                finally {
                    jis.close();
                }
            }
            catch (Exception ex) {
                logger.warn("Failed reading jar {} : {}", (Object)jarFile.getName(), (Object)ex.getMessage());
            }
        }
    }

    private void loadSystemFonts() {
        String[] fontDirs;
        for (String fd : fontDirs = new String[]{"C:\\Windows\\Fonts", "/usr/share/fonts", "/usr/local/share/fonts", "/Library/Fonts"}) {
            try {
                File[] files;
                File dir = new File(fd);
                if (!dir.exists() || !dir.isDirectory() || (files = dir.listFiles((d, n) -> n.toLowerCase().endsWith(".ttf") || n.toLowerCase().endsWith(".otf"))) == null) continue;
                for (File f : files) {
                    try (InputStream is = Files.newInputStream(f.toPath(), new OpenOption[0]);){
                        Font font = Font.createFont(0, is);
                        GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setupJasperReportsProperties() {
        try {
            System.setProperty("net.sf.jasperreports.text.markup.html", "html");
            System.setProperty("net.sf.jasperreports.markup.parser.html.enabled", "true");
            System.setProperty("net.sf.jasperreports.markup.processor.factory", "net.sf.jasperreports.engine.util.JRStyledTextProcessorFactory");
            System.setProperty("net.sf.jasperreports.default.font.name", "Times New Roman");
            System.setProperty("net.sf.jasperreports.default.pdf.encoding", "Identity-H");
            System.setProperty("net.sf.jasperreports.default.pdf.embedded", "true");
            System.setProperty("net.sf.jasperreports.export.pdf.font.embedded", "true");
            System.setProperty("net.sf.jasperreports.print.keep.full.text", "true");
            System.setProperty("net.sf.jasperreports.export.pdf.force.linebreak.policy", "true");
            System.setProperty("net.sf.jasperreports.awt.ignore.missing.font", "true");
            logger.info("Set JasperReports system properties for markup and font embedding.");
        }
        catch (Exception e) {
            logger.warn("Failed to set JasperReports system properties: {}", (Object)e.getMessage());
        }
    }

    public Map<String, Object> generateCertificatesAndReports(Long templateId, File excelFile, Map<String, File> uploadedFiles, String outputFolderPath, UserPrincipal currentUser) {
        try {
            Template template = (Template)this.templateRepository.findById((Object)templateId).orElseThrow(() -> new RuntimeException("Template not found with id: " + templateId));
            File outputFolder = new File(outputFolderPath);
            if (!outputFolder.exists() && !outputFolder.mkdirs()) {
                throw new RuntimeException("Failed to create output dir");
            }
            return this.generateCertificatesByType(template, excelFile, uploadedFiles, outputFolder, currentUser);
        }
        catch (Exception e) {
            logger.error("Generation failed", (Throwable)e);
            HashMap<String, Object> error = new HashMap<String, Object>();
            error.put("error", true);
            error.put("message", e.getMessage());
            error.put("pdfFiles", new ArrayList());
            error.put("candidates", new ArrayList());
            error.put("folderPath", "");
            return error;
        }
    }

    public Map<String, Object> generateCertificatesByType(Template template, File excelFile, Map<String, File> uploadedFiles, File outputFolder, UserPrincipal currentUser) throws Exception {
        this.loadAllFonts();
        int imageType = template.getImageType();
        switch (imageType) {
            case 1: {
                return this.generateType1Certificates(template, excelFile, uploadedFiles, outputFolder, currentUser);
            }
            case 2: {
                return this.generateType2Certificates(template, excelFile, uploadedFiles, outputFolder, currentUser);
            }
            case 3: {
                return this.generateType3Certificates(template, excelFile, uploadedFiles, outputFolder, currentUser);
            }
            case 4: {
                return this.generateType4Certificates(template, excelFile, outputFolder, currentUser);
            }
            case 5: {
                return this.generateType5Certificates(template, excelFile, outputFolder, currentUser);
            }
        }
        return this.generateType0Certificates(template, excelFile, outputFolder, currentUser);
    }

    private Map<String, Object> generateType0Certificates(Template template, File excelFile, File outputFolder, UserPrincipal currentUser) throws Exception {
        return this.generateWithStaticImages(template, excelFile, null, outputFolder, 0, null, currentUser);
    }

    private Map<String, Object> generateType1Certificates(Template template, File excelFile, Map<String, File> uploadedFiles, File outputFolder, UserPrincipal currentUser) throws Exception {
        File extracted = this.extractZipImages(uploadedFiles, outputFolder);
        return this.generateWithStaticImages(template, excelFile, extracted, outputFolder, 1, uploadedFiles, currentUser);
    }

    private Map<String, Object> generateType2Certificates(Template template, File excelFile, Map<String, File> uploadedFiles, File outputFolder, UserPrincipal currentUser) throws Exception {
        File extracted = this.extractZipImages(uploadedFiles, outputFolder);
        return this.generateWithStaticImages(template, excelFile, extracted, outputFolder, 2, uploadedFiles, currentUser);
    }

    private Map<String, Object> generateType3Certificates(Template template, File excelFile, Map<String, File> uploadedFiles, File outputFolder, UserPrincipal currentUser) throws Exception {
        File extracted = this.extractZipImages(uploadedFiles, outputFolder);
        return this.generateWithStaticImages(template, excelFile, extracted, outputFolder, 3, uploadedFiles, currentUser);
    }

    private Map<String, Object> generateType4Certificates(Template template, File excelFile, File outputFolder, UserPrincipal currentUser) throws Exception {
        logger.info("\ud83d\udcd8 Generating Type 4 Certificates (All Static Images)");
        return this.generateWithStaticImages(template, excelFile, null, outputFolder, 4, null, currentUser);
    }

    private Map<String, Object> generateType5Certificates(Template template, File excelFile, File outputFolder, UserPrincipal currentUser) throws Exception {
        logger.info(" Generating Type 5 Certificates (All Static Images - Alternate Layout)");
        return this.generateWithStaticImages(template, excelFile, null, outputFolder, 5, null, currentUser);
    }

    private File extractZipImages(Map<String, File> uploadedFiles, File outputFolder) throws IOException {
        if (uploadedFiles != null && uploadedFiles.containsKey("zipImage")) {
            File extracted = new File(outputFolder, "unzippedImages");
            if (!extracted.exists()) {
                extracted.mkdirs();
            }
            this.unzipAndRenameImages(uploadedFiles.get("zipImage"), extracted);
            return extracted;
        }
        return null;
    }

    private Map<String, Object> generateWithStaticImages(Template template, File excelFile, File extractedZipFolder, File outputFolder, int imageType, Map<String, File> uploadedFiles, UserPrincipal currentUser) throws Exception {
        ArrayList<File> pdfFiles = new ArrayList<File>();
        LinkedHashMap<String, CandidateDTO> uniqueBySid = new LinkedHashMap<String, CandidateDTO>();
        HashMap<String, Integer> sidIndexMap = new HashMap<String, Integer>();
        List candidates = this.parseExcel(excelFile, template);
        if (candidates == null || candidates.isEmpty()) {
            throw new Exception("No candidates found");
        }
        List templateStaticImages = this.loadStaticImages(template.getTemplateFolder());
        List baseStaticImages = this.loadStaticImages(this.baseTemplateFolder);
        for (CandidateDTO candidate : candidates) {
            Report report;
            String sid = candidate.getSid();
            if (sid == null || sid.trim().isEmpty()) continue;
            if (!uniqueBySid.containsKey(sid)) {
                uniqueBySid.put(sid, candidate);
                report = this.createReport(candidate, currentUser);
                this.reportService.saveOrUpdateBySid(report, currentUser);
                File pdfFile = this.generateCertificateForCandidate(template, candidate, templateStaticImages, baseStaticImages, extractedZipFolder, imageType, uploadedFiles, outputFolder);
                sidIndexMap.put(sid, pdfFiles.size());
                pdfFiles.add(pdfFile);
                continue;
            }
            uniqueBySid.put(sid, candidate);
            report = this.createReport(candidate, currentUser);
            this.reportService.saveOrUpdateBySid(report, currentUser);
            Integer idx = (Integer)sidIndexMap.get(sid);
            if (idx != null) {
                File old = (File)pdfFiles.get(idx);
                if (old.exists()) {
                    old.delete();
                }
                File pdfFile = this.generateCertificateForCandidate(template, candidate, templateStaticImages, baseStaticImages, extractedZipFolder, imageType, uploadedFiles, outputFolder);
                pdfFiles.set(idx, pdfFile);
                continue;
            }
            File pdfFile = this.generateCertificateForCandidate(template, candidate, templateStaticImages, baseStaticImages, extractedZipFolder, imageType, uploadedFiles, outputFolder);
            sidIndexMap.put(sid, pdfFiles.size());
            pdfFiles.add(pdfFile);
        }
        if (imageType == 4 || imageType == 5) {
            this.mergeType4AndType5Certificates(outputFolder, pdfFiles, uniqueBySid);
        }
        return this.createResultMap(pdfFiles, uniqueBySid, outputFolder);
    }

    private Report createReport(CandidateDTO candidate, UserPrincipal currentUser) {
        Report report = new Report();
        report.setSid(candidate.getSid());
        report.setCandidateName(candidate.getCandidateName());
        report.setGrade(candidate.getGrade());
        report.setBatchId(candidate.getBatchId());
        report.setTemplateName(candidate.getTemplate() != null ? candidate.getTemplate().getTemplateName() : null);
        report.setJobrole(candidate.getJobRole());
        report.setLevel(candidate.getLevel());
        report.setTemplate(candidate.getTemplate());
        return report;
    }

    private File generateCertificateForCandidate(Template template, CandidateDTO candidate, List<File> templateStaticImages, List<File> baseStaticImages, File extractedZipFolder, int imageType, Map<String, File> uploadedFiles, File outputFolder) throws Exception {
        JasperReport jasperReport;
        if (template.getJrxmlPath() == null || template.getJrxmlPath().trim().isEmpty()) {
            throw new IllegalArgumentException("JRXML path missing");
        }
        try (FileInputStream jrxmlStream = new FileInputStream(new File(template.getJrxmlPath()));){
            jasperReport = JasperCompileManager.compileReport((InputStream)jrxmlStream);
        }
        Map parameters = this.createJasperParameters();
        this.setupImageParameters(parameters, templateStaticImages, baseStaticImages, extractedZipFolder, imageType, uploadedFiles, candidate);
        CandidateDTO dataCandidate = this.createModifiedCandidateForHtml(candidate);
        try {
            JasperDesign design = JRXmlLoader.load((File)new File(template.getJrxmlPath()));
            if (design.getFieldsList() != null) {
                HashSet<String> fields = new HashSet<String>();
                design.getFieldsList().forEach(f -> fields.add(f.getName()));
                fields.removeIf(Objects::isNull);
                logger.debug("JRXML Fields: {}", fields);
            }
            if (design.getParametersList() != null) {
                HashSet params = new HashSet();
                design.getParametersList().forEach(p -> {
                    if (!p.isSystemDefined()) {
                        params.add(p.getName());
                    }
                });
                logger.debug("JRXML Parameters: {}", params);
            }
        }
        catch (Exception e) {
            logger.debug("Could not load JasperDesign for debugging: {}", (Object)e.getMessage());
        }
        DefaultJasperReportsContext ctx = DefaultJasperReportsContext.getInstance();
        JRPropertiesUtil.getInstance((JasperReportsContext)ctx).setProperty("net.sf.jasperreports.markup.html", "styled");
        JRPropertiesUtil.getInstance((JasperReportsContext)ctx).setProperty("net.sf.jasperreports.text.markup.html", "styled");
        JRPropertiesUtil.getInstance((JasperReportsContext)ctx).setProperty("net.sf.jasperreports.export.pdf.styled.text", "true");
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, (Map)parameters, (JRDataSource)new JRBeanCollectionDataSource(Collections.singletonList(dataCandidate)));
        return this.exportToPdf(jasperPrint, candidate, outputFolder, imageType);
    }

    private CandidateDTO createModifiedCandidateForHtml(CandidateDTO original) {
        CandidateDTO m = new CandidateDTO();
        m.setSalutation(original.getSalutation());
        m.setCandidateName(original.getCandidateName());
        m.setJobRole(original.getJobRole());
        m.setGuardianType(original.getGuardianType());
        m.setFatherORHusbandName(original.getFatherORHusbandName());
        m.setSectorSkillCouncil(original.getSectorSkillCouncil());
        m.setDateOfIssuance(original.getDateOfIssuance());
        m.setLevel(original.getLevel());
        m.setAadhaarNumber(original.getAadhaarNumber());
        m.setSector(original.getSector());
        m.setGrade(original.getGrade());
        m.setDateOfStart(original.getDateOfStart());
        m.setDateOfEnd(original.getDateOfEnd());
        m.setMarks(original.getMarks());
        m.setMarks1(original.getMarks1());
        m.setMarks2(original.getMarks2());
        m.setMarks3(original.getMarks3());
        m.setMarks4(original.getMarks4());
        m.setMarks5(original.getMarks5());
        m.setMarks6(original.getMarks6());
        m.setMarks7(original.getMarks7());
        m.setMarks8(original.getMarks8());
        m.setMarks9(original.getMarks9());
        m.setMarks10(original.getMarks10());
        m.setBatchId(original.getBatchId());
        m.setState(original.getState());
        m.setDistrict(original.getDistrict());
        m.setCourseName(original.getCourseName());
        m.setDuration(original.getDuration());
        m.setPlace(original.getPlace());
        m.setTemplate(original.getTemplate());
        m.setSid(original.getSid());
        return m;
    }

    private Map<String, Object> createJasperParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("REPORT_LOCALE", Locale.ENGLISH);
        parameters.put("net.sf.jasperreports.default.font.name", "Times New Roman");
        parameters.put("net.sf.jasperreports.default.pdf.encoding", "Identity-H");
        parameters.put("net.sf.jasperreports.default.pdf.embedded", true);
        parameters.put("net.sf.jasperreports.export.pdf.font.embedded", true);
        parameters.put("net.sf.jasperreports.print.keep.full.text", true);
        parameters.put("net.sf.jasperreports.export.pdf.force.linebreak.policy", true);
        parameters.put("net.sf.jasperreports.text.truncate.at.char", false);
        parameters.put("net.sf.jasperreports.text.truncate.suffix", "");
        parameters.put("net.sf.jasperreports.text.markup.html", "html");
        parameters.put("net.sf.jasperreports.markup.parser.html.enabled", true);
        parameters.put("net.sf.jasperreports.awt.ignore.missing.font", "true");
        return parameters;
    }

    private void setupImageParameters(Map<String, Object> parameters, List<File> templateStaticImages, List<File> baseStaticImages, File extractedZipFolder, int imageType, Map<String, File> uploadedFiles, CandidateDTO candidate) {
        File candidateImg;
        File bg;
        ArrayList<File> all = new ArrayList<File>();
        if (templateStaticImages != null) {
            all.addAll(templateStaticImages);
        }
        if (baseStaticImages != null) {
            all.addAll(baseStaticImages);
        }
        if ((bg = (File)all.stream().filter(f -> f.getName().toLowerCase().contains("bg")).findFirst().orElse(null)) != null) {
            parameters.put("imgParamBG", bg.getAbsolutePath());
        }
        int idx = 1;
        for (File f2 : all) {
            if (bg != null && f2.equals(bg)) continue;
            parameters.put("imgParam" + idx++, f2.getAbsolutePath());
            if (idx <= 15) continue;
            break;
        }
        if (imageType >= 1 && extractedZipFolder != null && (candidateImg = this.findCandidateImage(extractedZipFolder, candidate.getSid())) != null) {
            parameters.put("imgParam3", candidateImg.getAbsolutePath());
        }
        if (imageType >= 2 && uploadedFiles != null && uploadedFiles.containsKey("logo")) {
            parameters.put("imgParam5", uploadedFiles.get("logo").getAbsolutePath());
        }
        if (imageType >= 3 && uploadedFiles != null && uploadedFiles.containsKey("signature")) {
            parameters.put("imgParam6", uploadedFiles.get("signature").getAbsolutePath());
        }
    }

    private File exportToPdf(JasperPrint jasperPrint, CandidateDTO candidate, File outputFolder, int imageType) throws JRException {
        String safeName = candidate.getCandidateName() == null ? "unknown" : candidate.getCandidateName().replaceAll("[^a-zA-Z0-9\\-_]", "_");
        String sid = candidate.getSid() == null ? String.valueOf(System.currentTimeMillis()) : candidate.getSid().replaceAll("[^a-zA-Z0-9\\-_]", "_");
        String pdfName = sid + "_" + safeName + "_type" + imageType + ".pdf";
        File out = new File(outputFolder, pdfName);
        JRPdfExporter exporter = new JRPdfExporter();
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(out));
        SimplePdfReportConfiguration reportConfig = new SimplePdfReportConfiguration();
        reportConfig.setForceLineBreakPolicy(Boolean.valueOf(true));
        reportConfig.setForceSvgShapes(Boolean.valueOf(true));
        SimplePdfExporterConfiguration exportConfig = new SimplePdfExporterConfiguration();
        exportConfig.setPdfaConformance(PdfaConformanceEnum.NONE);
        exportConfig.setMetadataAuthor("Certificate Generator");
        exportConfig.setTagged(Boolean.valueOf(true));
        exporter.setConfiguration((ReportExportConfiguration)reportConfig);
        exporter.setConfiguration((ExporterConfiguration)exportConfig);
        exporter.exportReport();
        logger.info("Generated PDF: {}", (Object)out.getAbsolutePath());
        return out;
    }

    private Map<String, Object> createResultMap(List<File> pdfFiles, Map<String, CandidateDTO> uniqueBySid, File outputFolder) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("error", false);
        result.put("message", "Certificates generated");
        result.put("pdfFiles", pdfFiles);
        result.put("candidates", new ArrayList<CandidateDTO>(uniqueBySid.values()));
        result.put("folderPath", outputFolder.getAbsolutePath());
        result.put("totalGenerated", pdfFiles.size());
        return result;
    }

    private List<File> loadStaticImages(String folderPath) {
        ArrayList<File> images = new ArrayList<File>();
        if (folderPath == null) {
            return images;
        }
        File folder = new File(folderPath);
        if (!folder.exists() || !folder.isDirectory()) {
            return images;
        }
        File[] files = folder.listFiles();
        if (files == null) {
            return images;
        }
        for (File f : files) {
            if (!f.isFile() || !this.isImageFile(f.getName())) continue;
            images.add(f);
        }
        return images;
    }

    private void unzipAndRenameImages(File zipFile, File destDir) throws IOException {
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                String entryName = new File(entry.getName()).getName();
                int dot = entryName.lastIndexOf(46);
                String ext = dot > 0 ? entryName.substring(dot).toLowerCase() : "";
                String name = dot > 0 ? entryName.substring(0, dot) : entryName;
                File newFile = new File(destDir, name + ext);
                try (FileOutputStream fos = new FileOutputStream(newFile);){
                    int len;
                    byte[] buf = new byte[1024];
                    while ((len = zis.read(buf)) > 0) {
                        fos.write(buf, 0, len);
                    }
                }
                zis.closeEntry();
            }
        }
    }

    private File findCandidateImage(File folder, String sid) {
        if (folder == null || sid == null) {
            return null;
        }
        File[] files = folder.listFiles();
        if (files == null) {
            return null;
        }
        for (File f : files) {
            if (!f.getName().toLowerCase().contains(sid.toLowerCase()) || !this.isImageFile(f.getName())) continue;
            return f;
        }
        return null;
    }

    private boolean isImageFile(String name) {
        String n = name.toLowerCase();
        return n.endsWith(".jpg") || n.endsWith(".jpeg") || n.endsWith(".png") || n.endsWith(".gif") || n.endsWith(".bmp");
    }

    private List<CandidateDTO> parseExcel(File excelFile, Template template) throws Exception {
        ArrayList<CandidateDTO> candidates = new ArrayList<CandidateDTO>();
        if (excelFile == null || !excelFile.exists()) {
            throw new FileNotFoundException("Excel file missing");
        }
        try (FileInputStream fis = new FileInputStream(excelFile);
             Workbook workbook = WorkbookFactory.create((InputStream)fis);){
            Sheet sheet = workbook.getSheetAt(0);
            if (sheet == null) {
                throw new Exception("No sheet");
            }
            for (int i = 1; i <= sheet.getLastRowNum(); ++i) {
                CandidateDTO c;
                Row row = sheet.getRow(i);
                if (row == null || this.isRowEmpty(row) || !this.isValidCandidate(c = this.createCandidateFromRow(row, template))) continue;
                candidates.add(c);
            }
        }
        return candidates;
    }

    private CandidateDTO createCandidateFromRow(Row row, Template template) {
        CandidateDTO candidate = new CandidateDTO();
        candidate.setSalutation(this.getSafeCellValue(row.getCell(0)));
        candidate.setCandidateName(this.getSafeCellValue(row.getCell(1)));
        candidate.setSid(this.getSafeCellValue(row.getCell(2)));
        candidate.setJobRole(this.getSafeCellValue(row.getCell(3)));
        candidate.setGuardianType(this.getSafeCellValue(row.getCell(4)));
        candidate.setFatherORHusbandName(this.getSafeCellValue(row.getCell(5)));
        candidate.setSectorSkillCouncil(this.getSafeCellValue(row.getCell(6)));
        candidate.setDateOfIssuance(this.getSafeCellValue(row.getCell(7)));
        candidate.setLevel(this.getSafeCellValue(row.getCell(8)));
        candidate.setAadhaarNumber(this.getSafeCellValue(row.getCell(9)));
        candidate.setSector(this.getSafeCellValue(row.getCell(10)));
        candidate.setGrade(this.getSafeCellValue(row.getCell(11)));
        candidate.setDateOfStart(this.getSafeCellValue(row.getCell(12)));
        candidate.setDateOfEnd(this.getSafeCellValue(row.getCell(13)));
        candidate.setMarks(this.getSafeCellValue(row.getCell(14)));
        candidate.setMarks1(this.getSafeCellValue(row.getCell(15)));
        candidate.setMarks2(this.getSafeCellValue(row.getCell(16)));
        candidate.setMarks3(this.getSafeCellValue(row.getCell(17)));
        candidate.setMarks4(this.getSafeCellValue(row.getCell(18)));
        candidate.setMarks5(this.getSafeCellValue(row.getCell(19)));
        candidate.setMarks6(this.getSafeCellValue(row.getCell(20)));
        candidate.setMarks7(this.getSafeCellValue(row.getCell(21)));
        candidate.setMarks8(this.getSafeCellValue(row.getCell(22)));
        candidate.setMarks9(this.getSafeCellValue(row.getCell(23)));
        candidate.setMarks10(this.getSafeCellValue(row.getCell(24)));
        candidate.setBatchId(this.getSafeCellValue(row.getCell(25)));
        candidate.setState(this.getSafeCellValue(row.getCell(26)));
        candidate.setDistrict(this.getSafeCellValue(row.getCell(27)));
        candidate.setPlace(this.getSafeCellValue(row.getCell(28)));
        candidate.setTemplate(template);
        return candidate;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getSafeCellValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        try {
            switch (1.$SwitchMap$org$apache$poi$ss$usermodel$CellType[cell.getCellType().ordinal()]) {
                case 1: {
                    return cell.getStringCellValue().trim();
                }
                case 2: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        return new SimpleDateFormat("dd-MM-yyyy").format(cell.getDateCellValue());
                    }
                    double val = cell.getNumericCellValue();
                    if (val == Math.floor(val)) {
                        return String.valueOf((long)val);
                    }
                    return String.valueOf(val);
                }
                case 3: {
                    return String.valueOf(cell.getBooleanCellValue());
                }
                case 4: {
                    try {
                        FormulaEvaluator evaluator = cell.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
                        CellValue cv = evaluator.evaluate(cell);
                        switch (1.$SwitchMap$org$apache$poi$ss$usermodel$CellType[cv.getCellType().ordinal()]) {
                            case 1: {
                                return cv.getStringValue().trim();
                            }
                            case 2: {
                                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                    return new SimpleDateFormat("dd-MM-yyyy").format(cell.getDateCellValue());
                                }
                                double fv = cv.getNumberValue();
                                if (fv == Math.floor(fv)) {
                                    return String.valueOf((long)fv);
                                }
                                return String.valueOf(fv);
                            }
                            case 3: {
                                return String.valueOf(cv.getBooleanValue());
                            }
                        }
                        return "";
                    }
                    catch (Exception e) {
                        return cell.toString().trim();
                    }
                }
            }
            return cell.toString().trim();
        }
        catch (Exception e) {
            return "";
        }
    }

    private boolean isRowEmpty(Row row) {
        if (row == null) {
            return true;
        }
        for (Cell cell : row) {
            if (cell == null || cell.getCellType() == CellType.BLANK || cell.toString().trim().length() <= 0) continue;
            return false;
        }
        return true;
    }

    private boolean isValidCandidate(CandidateDTO c) {
        return c.getSid() != null && !c.getSid().trim().isEmpty() && c.getCandidateName() != null && !c.getCandidateName().trim().isEmpty();
    }

    private void mergeType4AndType5Certificates(File outputFolder, List<File> pdfFiles, Map<String, CandidateDTO> uniqueBySid) {
        try {
            logger.info("Starting Type 4 and Type 5 certificate merging...");
            HashMap<String, List> pdfsBySid = new HashMap<String, List>();
            for (File pdfFile : pdfFiles) {
                String fileName = pdfFile.getName();
                String[] parts = fileName.split("_");
                if (parts.length < 3) continue;
                String sid = parts[0];
                pdfsBySid.computeIfAbsent(sid, k -> new ArrayList()).add(pdfFile);
            }
            ArrayList<File> mergedFiles = new ArrayList<File>();
            for (Map.Entry entry : pdfsBySid.entrySet()) {
                File mergedFile;
                String sid = (String)entry.getKey();
                List candidatePdfs = (List)entry.getValue();
                if (candidatePdfs.size() < 2) continue;
                File type4Pdf = null;
                File type5Pdf = null;
                for (File pdf : candidatePdfs) {
                    if (pdf.getName().contains("_type4.")) {
                        type4Pdf = pdf;
                        continue;
                    }
                    if (!pdf.getName().contains("_type5.")) continue;
                    type5Pdf = pdf;
                }
                if (type4Pdf == null || type5Pdf == null || (mergedFile = this.mergeTwoPdfs(type4Pdf, type5Pdf, sid, outputFolder)) == null) continue;
                mergedFiles.add(mergedFile);
                logger.info("Merged Type 4 and Type 5 for SID: {}", (Object)sid);
                type4Pdf.delete();
                type5Pdf.delete();
            }
            if (!mergedFiles.isEmpty()) {
                pdfFiles.removeIf(file -> file.getName().contains("_type4.") || file.getName().contains("_type5."));
                pdfFiles.addAll(mergedFiles);
                logger.info("Completed merging. Total merged files: {}", (Object)mergedFiles.size());
            }
        }
        catch (Exception e) {
            logger.error("Error during Type 4 and Type 5 certificate merging: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private File mergeTwoPdfs(File pdf1, File pdf2, String sid, File outputFolder) {
        try {
            CandidateDTO candidate = this.findCandidateBySid(sid);
            String safeName = candidate != null && candidate.getCandidateName() != null ? candidate.getCandidateName().replaceAll("[^a-zA-Z0-9\\-_]", "_") : "unknown";
            String mergedFileName = sid + "_" + safeName + "_merged.pdf";
            File mergedFile = new File(outputFolder, mergedFileName);
            PDFMergerUtility merger = new PDFMergerUtility();
            merger.addSource(pdf1);
            merger.addSource(pdf2);
            merger.setDestinationFileName(mergedFile.getAbsolutePath());
            merger.mergeDocuments(null);
            return mergedFile;
        }
        catch (Exception e) {
            logger.error("Error merging PDFs for SID {}: {}", new Object[]{sid, e.getMessage(), e});
            return null;
        }
    }

    private CandidateDTO findCandidateBySid(String sid) {
        return null;
    }
}

