/*
 * Decompiled with CFR 0.152.
 */
package Tech_Nagendra.Certificates_genration.Service;

import jakarta.annotation.PostConstruct;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Service;

@Service
public class DynamicFontService {
    @Value(value="${custom.fonts.dir:src/main/resources/fonts}")
    private String customFontsDir;
    private final Map<String, Font> loadedFonts = new ConcurrentHashMap();
    private final Set<String> availableFontFamilies = ConcurrentHashMap.newKeySet();
    private boolean fontsInitialized = false;

    @PostConstruct
    public void autoLoadFonts() {
        new Thread(() -> {
            try {
                Thread.sleep(3000L);
                this.loadFontsDynamically();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }).start();
    }

    public synchronized void loadFontsDynamically() {
        if (this.fontsInitialized) {
            System.out.println("Fonts already initialized");
            return;
        }
        try {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            int count = this.loadFontsFromClasspath("classpath:fonts/**/*.ttf");
            count += this.loadFontsFromClasspath("classpath:fonts/**/*.otf");
            count += this.loadFontsFromClasspath("classpath:fonts/**/*.jar");
            count += this.loadFontsFromPath(this.customFontsDir);
            this.registerFontsWithSystem(ge);
            this.collectAvailableFontFamilies(ge);
            this.fontsInitialized = true;
        }
        catch (Exception e) {
            System.err.println(" Error in dynamic font loading: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private int loadFontsFromClasspath(String pattern) {
        int count = 0;
        try {
            Resource[] resources;
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            for (Resource resource : resources = resolver.getResources(pattern)) {
                String filename = resource.getFilename();
                if (filename == null) continue;
                if (filename.toLowerCase().endsWith(".jar")) {
                    count += this.loadFontsFromJar(resource);
                    continue;
                }
                count += this.loadIndividualFontFile(resource, filename);
            }
        }
        catch (Exception e) {
            System.err.println("Error loading fonts from classpath: " + e.getMessage());
        }
        return count;
    }

    private int loadIndividualFontFile(Resource resource, String filename) {
        int n;
        block8: {
            InputStream is = resource.getInputStream();
            try {
                Font font = Font.createFont(0, is);
                this.loadedFonts.putIfAbsent(filename, font);
                System.out.println("Loaded classpath font: " + filename);
                n = 1;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    System.err.println("Error loading font " + filename + ": " + e.getMessage());
                    return 0;
                }
            }
            is.close();
        }
        return n;
    }

    private int loadFontsFromJar(Resource jarResource) {
        int count = 0;
        try {
            File tempJar = File.createTempFile("font_", ".jar");
            try (InputStream is = jarResource.getInputStream();
                 FileOutputStream fos = new FileOutputStream(tempJar);){
                is.transferTo(fos);
            }
            try (JarFile jarFile = new JarFile(tempJar);){
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (entry.isDirectory() || !entry.getName().endsWith(".ttf") && !entry.getName().endsWith(".otf")) continue;
                    InputStream is = jarFile.getInputStream(entry);
                    try {
                        Font font = Font.createFont(0, is);
                        this.loadedFonts.putIfAbsent(entry.getName(), font);
                        ++count;
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error loading fonts from JAR " + jarResource.getFilename() + ": " + e.getMessage());
        }
        return count;
    }

    private int loadFontsFromPath(String directoryPath) {
        int count = 0;
        try {
            File dir = new File(directoryPath);
            if (!dir.exists() || !dir.isDirectory()) {
                return 0;
            }
            File[] files = dir.listFiles((d, name) -> name.toLowerCase().endsWith(".ttf") || name.toLowerCase().endsWith(".otf") || name.toLowerCase().endsWith(".jar"));
            if (files != null) {
                for (File file : files) {
                    if (file.getName().endsWith(".jar")) {
                        count += this.loadFontsFromExternalJar(file);
                        continue;
                    }
                    count += this.loadIndividualExternalFont(file);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error loading fonts from " + directoryPath + ": " + e.getMessage());
        }
        return count;
    }

    private int loadFontsFromExternalJar(File jarFile) {
        int count = 0;
        try (JarFile jar = new JarFile(jarFile);){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory() || !entry.getName().endsWith(".ttf") && !entry.getName().endsWith(".otf")) continue;
                InputStream is = jar.getInputStream(entry);
                try {
                    Font font = Font.createFont(0, is);
                    this.loadedFonts.putIfAbsent(entry.getName(), font);
                    ++count;
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error reading external JAR: " + e.getMessage());
        }
        return count;
    }

    private int loadIndividualExternalFont(File file) {
        try {
            Font font = Font.createFont(0, file);
            this.loadedFonts.putIfAbsent(file.getName(), font);
            System.out.println("Loaded external font: " + file.getName());
            return 1;
        }
        catch (Exception e) {
            System.err.println("Error loading external font " + file.getName() + ": " + e.getMessage());
            return 0;
        }
    }

    private void registerFontsWithSystem(GraphicsEnvironment ge) {
        int count = 0;
        for (Font font : this.loadedFonts.values()) {
            try {
                ge.registerFont(font);
                ++count;
            }
            catch (Exception exception) {}
        }
    }

    private void collectAvailableFontFamilies(GraphicsEnvironment ge) {
        this.availableFontFamilies.clear();
        this.availableFontFamilies.addAll(Arrays.asList(ge.getAvailableFontFamilyNames()));
    }

    public Font getFont(String fontName, int style, float size) {
        for (Map.Entry entry : this.loadedFonts.entrySet()) {
            if (!((String)entry.getKey()).toLowerCase().contains(fontName.toLowerCase())) continue;
            return ((Font)entry.getValue()).deriveFont(style, size);
        }
        return new Font(fontName, style, (int)size);
    }

    public Map<String, Object> getFontInfo() {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("loadedFontFiles", this.loadedFonts.size());
        info.put("availableFontFamilies", this.availableFontFamilies.size());
        info.put("fontsInitialized", this.fontsInitialized);
        info.put("fontDirectory", this.customFontsDir);
        info.put("timestamp", new Date());
        return info;
    }

    public void reloadFonts() {
        this.fontsInitialized = false;
        this.loadedFonts.clear();
        this.availableFontFamilies.clear();
        this.loadFontsDynamically();
    }

    public Set<String> getAvailableFontFamilies() {
        if (this.availableFontFamilies.isEmpty()) {
            this.collectAvailableFontFamilies(GraphicsEnvironment.getLocalGraphicsEnvironment());
        }
        return new HashSet<String>(this.availableFontFamilies);
    }

    public boolean isFontFamilyAvailable(String fontName) {
        return this.availableFontFamilies.stream().anyMatch(f -> f.equalsIgnoreCase(fontName));
    }
}

