/*
 * Decompiled with CFR 0.152.
 */
package Tech_Nagendra.Certificates_genration.Service;

import Tech_Nagendra.Certificates_genration.Entity.Report;
import Tech_Nagendra.Certificates_genration.Entity.UserProfile;
import Tech_Nagendra.Certificates_genration.Repository.ReportRepository;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfWriter;
import jakarta.mail.internet.MimeMessage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class EmailSchedulerService {
    private static final Logger log = LoggerFactory.getLogger(EmailSchedulerService.class);
    @Autowired
    private ReportRepository reportRepository;
    @Autowired
    private JavaMailSender mailSender;
    @Value(value="${mail.test.mode:true}")
    private boolean testMode;
    @Value(value="${mail.test.recipient:}")
    private String testRecipient;
    @Value(value="${mail.from:no-reply@example.com}")
    private String mailFrom;
    private volatile LocalDateTime lastRunAt;
    private volatile String lastRunStatus;
    private volatile String lastRunError;

    @Scheduled(cron="0 1 9 13 * *")
    public void sendMonthlyReports() {
        this.lastRunAt = LocalDateTime.now(ZoneId.of("Asia/Kolkata"));
        this.lastRunStatus = "STARTED";
        this.lastRunError = null;
        try {
            LocalDate startDate = LocalDate.now(ZoneId.of("Asia/Kolkata")).minusMonths(1L).withDayOfMonth(1);
            LocalDate endDate = startDate.withDayOfMonth(startDate.lengthOfMonth());
            Date start = Date.from(startDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
            Date end = Date.from(endDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
            List allReports = this.reportRepository.findAll();
            Map<UserProfile, List<Report>> grouped = allReports.stream().filter(r -> r.getGeneratedOn() != null && !r.getGeneratedOn().before(start) && !r.getGeneratedOn().after(end) && r.getGeneratedBy() != null).collect(Collectors.groupingBy(Report::getGeneratedBy));
            if (grouped.isEmpty()) {
                this.lastRunStatus = "NO_DATA";
                log.info("No reports found between {} and {}", (Object)startDate, (Object)endDate);
                return;
            }
            for (Map.Entry<UserProfile, List<Report>> entry : grouped.entrySet()) {
                UserProfile user = entry.getKey();
                List<Report> reports = entry.getValue();
                int count = reports.size();
                try {
                    Long userId = user.getId();
                    Object username = user.getUsername() != null ? user.getUsername() : "User_" + userId;
                    Object email = user.getEmail() != null ? user.getEmail() : "user" + userId + "@example.com";
                    String filePath = this.generateInvoice(userId, count, startDate, endDate);
                    boolean sent = this.sendEmailWithAttachment((String)email, (String)username, count, filePath);
                    if (sent) {
                        log.info("Email sent successfully for userId={} ({})", (Object)userId, email);
                    } else {
                        log.info("Test mode: email not sent for userId={} ({})", (Object)userId, email);
                    }
                    try {
                        File f = new File(filePath);
                        if (!f.exists()) continue;
                        f.delete();
                    }
                    catch (Exception exception) {
                    }
                }
                catch (Exception e) {
                    log.error("Error sending mail to user {} : {}", new Object[]{user.getId(), e.getMessage(), e});
                }
            }
            this.lastRunStatus = "SUCCESS";
        }
        catch (Exception e) {
            this.lastRunStatus = "FAILED";
            this.lastRunError = e.getMessage();
            log.error("Monthly report failed at {} : {}", new Object[]{this.lastRunAt, e.getMessage(), e});
        }
    }

    private String generateInvoice(Long userId, int count, LocalDate start, LocalDate end) throws Exception {
        LocalDateTime now = LocalDateTime.now(ZoneId.of("Asia/Kolkata"));
        DateTimeFormatter fileFormatter = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");
        String timestamp = now.format(fileFormatter);
        String monthYear = start.getMonthValue() + "_" + start.getYear();
        String folderPath = "C:/certificate_storage/invoices/";
        File folder = new File(folderPath);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        String fileName = folderPath + "invoice_" + userId + "_" + monthYear + "_" + timestamp + ".pdf";
        Document document = new Document();
        PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(fileName));
        document.open();
        document.add((Element)new Paragraph("Certificate Generation Invoice"));
        document.add((Element)new Paragraph("Generated On: " + now.format(DateTimeFormatter.ofPattern("dd MMM yyyy, hh:mm a")) + " (IST)"));
        document.add((Element)new Paragraph("User ID: " + userId));
        document.add((Element)new Paragraph("Period: " + start + " to " + end));
        document.add((Element)new Paragraph("Certificates Generated: " + count));
        document.add((Element)new Paragraph("Amount: \u20b9" + count * 5));
        document.add((Element)new Paragraph("\nThank you for using our service!"));
        document.close();
        return fileName;
    }

    private boolean sendEmailWithAttachment(String toEmail, String username, int count, String filePath) throws Exception {
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true);
        String monthYear = LocalDate.now(ZoneId.of("Asia/Kolkata")).minusMonths(1L).format(DateTimeFormatter.ofPattern("MMMM yyyy"));
        helper.setFrom(this.mailFrom);
        helper.setSubject("Monthly Certificate Summary & Invoice - " + monthYear);
        String body = "<p>Dear " + username + ",</p><p>We hope this message finds you well.</p><p>You generated <strong>" + count + "</strong> certificates during <strong>" + monthYear + "</strong>.</p><p>Please find the attached invoice for your records.</p><br><p>Warm regards,<br><strong>Certificate Generation Team</strong></p>";
        helper.setText(body, true);
        File attachment = new File(filePath);
        if (attachment.exists()) {
            helper.addAttachment(attachment.getName(), attachment);
        } else {
            log.warn("Attachment not found: {}", (Object)filePath);
        }
        if (this.testMode) {
            if (this.testRecipient != null && !this.testRecipient.isBlank()) {
                helper.setTo(this.testRecipient);
                this.mailSender.send(message);
                return true;
            }
            log.info("Test mode: email not sent to {}", (Object)toEmail);
            return false;
        }
        helper.setTo(toEmail);
        this.mailSender.send(message);
        return true;
    }
}

