/*
 * Decompiled with CFR 0.152.
 */
package Tech_Nagendra.Certificates_genration.Service;

import Tech_Nagendra.Certificates_genration.Dto.ProfileDto;
import Tech_Nagendra.Certificates_genration.Dto.ProfileStatsDto;
import Tech_Nagendra.Certificates_genration.Dto.UpdatePasswordDto;
import Tech_Nagendra.Certificates_genration.Entity.UserProfile;
import Tech_Nagendra.Certificates_genration.Repository.ProfileRepository;
import Tech_Nagendra.Certificates_genration.Repository.ReportRepository;
import Tech_Nagendra.Certificates_genration.Utility.JwtUtil;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.MalformedJwtException;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class ProfileService {
    private final ProfileRepository profileRepository;
    private final ReportRepository reportRepository;
    private final JwtUtil jwtUtil;
    private final PasswordEncoder passwordEncoder;

    public ProfileDto registerUser(ProfileDto profileDto, String rawPassword) {
        if (profileDto.getEmail() == null || profileDto.getUsername() == null || rawPassword == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Email, Username and Password are required");
        }
        if (this.profileRepository.existsByEmail(profileDto.getEmail())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, "Email already exists");
        }
        if (this.profileRepository.existsByUsername(profileDto.getUsername())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, "Username already exists");
        }
        UserProfile newUser = new UserProfile();
        newUser.setName(profileDto.getName());
        newUser.setUsername(profileDto.getUsername());
        newUser.setEmail(profileDto.getEmail());
        newUser.setPassword(this.passwordEncoder.encode((CharSequence)rawPassword));
        newUser.setRole(profileDto.getRole() != null ? profileDto.getRole() : "USER");
        newUser.setCreatedAt(LocalDateTime.now());
        newUser.setModifiedAt(LocalDateTime.now());
        newUser.setCreatedBy(null);
        newUser.setModifiedBy(null);
        UserProfile savedUser = (UserProfile)this.profileRepository.save((Object)newUser);
        return this.mapToDto(savedUser);
    }

    public ProfileDto getProfile(String token) {
        Long currentUserId = this.extractAndValidateToken(token);
        UserProfile user = this.findById(currentUserId);
        return this.mapToDto(user);
    }

    public ProfileDto updateProfile(String token, ProfileDto profileDto) {
        UserProfile currentUser;
        Long currentUserId = this.extractAndValidateToken(token);
        UserProfile targetUser = currentUser = this.findById(currentUserId);
        if (profileDto.getName() != null && !profileDto.getName().isBlank()) {
            targetUser.setName(profileDto.getName());
        }
        if (profileDto.getUsername() != null && !profileDto.getUsername().isBlank()) {
            targetUser.setUsername(profileDto.getUsername());
        }
        if (profileDto.getEmail() != null && !profileDto.getEmail().isBlank()) {
            targetUser.setEmail(profileDto.getEmail());
        }
        targetUser.setModifiedBy(currentUser);
        targetUser.setModifiedAt(LocalDateTime.now());
        UserProfile updated = (UserProfile)this.profileRepository.save((Object)targetUser);
        return this.mapToDto(updated);
    }

    public boolean updatePassword(String token, UpdatePasswordDto dto) {
        Long currentUserId = this.extractAndValidateToken(token);
        UserProfile user = this.findById(currentUserId);
        if (!this.passwordEncoder.matches((CharSequence)dto.getCurrentPassword(), user.getPassword())) {
            return false;
        }
        user.setPassword(this.passwordEncoder.encode((CharSequence)dto.getNewPassword()));
        user.setModifiedBy(user);
        user.setModifiedAt(LocalDateTime.now());
        this.profileRepository.save((Object)user);
        return true;
    }

    public ProfileStatsDto getStats(String token) {
        Long currentUserId = this.extractAndValidateToken(token);
        this.findById(currentUserId);
        long totalCertificates = this.reportRepository.countByGeneratedBy_Id(currentUserId);
        long activeCertificates = this.reportRepository.countByGeneratedBy_IdAndStatus(currentUserId, "ACTIVE");
        Optional lastReport = this.reportRepository.findTopByGeneratedBy_IdOrderByGeneratedOnDesc(currentUserId);
        String lastGenerated = lastReport.map(r -> r.getGeneratedOn().toString()).orElse("N/A");
        return new ProfileStatsDto((int)totalCertificates, (int)activeCertificates, lastGenerated);
    }

    public UserProfile findById(Long userId) {
        return (UserProfile)this.profileRepository.findById((Object)userId).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "User not found with ID: " + userId));
    }

    public List<Map<String, Object>> getAllUsers(String token) {
        this.extractAndValidateToken(token);
        try {
            return this.profileRepository.findAll().stream().map(u -> {
                HashMap<String, Object> userMap = new HashMap<String, Object>();
                userMap.put("id", u.getId());
                userMap.put("name", u.getName());
                userMap.put("email", u.getEmail());
                return userMap;
            }).toList();
        }
        catch (Exception e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Failed to fetch user list");
        }
    }

    public void saveLoginToken(Long userId, String token) {
        UserProfile user = this.findById(userId);
        user.setLoginToken(token);
        this.profileRepository.save((Object)user);
    }

    private Long extractAndValidateToken(String token) {
        if (token == null || token.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Authorization token required");
        }
        try {
            Long userId = this.jwtUtil.extractUserId(token);
            UserProfile user = this.findById(userId);
            if (user.getLoginToken() == null || !user.getLoginToken().equals(token)) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Invalid or expired token");
            }
            return userId;
        }
        catch (ExpiredJwtException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Token expired");
        }
        catch (MalformedJwtException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Invalid token format");
        }
        catch (Exception e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Token validation failed: " + e.getMessage());
        }
    }

    private ProfileDto mapToDto(UserProfile user) {
        return new ProfileDto(user.getId(), user.getName(), user.getUsername(), user.getEmail(), user.getRole(), user.getCreatedAt(), user.getModifiedAt(), user.getCreatedBy() != null ? user.getCreatedBy().getId() : null, user.getModifiedBy() != null ? user.getModifiedBy().getId() : null);
    }

    public ProfileService(ProfileRepository profileRepository, ReportRepository reportRepository, JwtUtil jwtUtil, PasswordEncoder passwordEncoder) {
        this.profileRepository = profileRepository;
        this.reportRepository = reportRepository;
        this.jwtUtil = jwtUtil;
        this.passwordEncoder = passwordEncoder;
    }
}

