/*
 * Decompiled with CFR 0.152.
 */
package Tech_Nagendra.Certificates_genration.Service;

import Tech_Nagendra.Certificates_genration.Dto.ReportDTO;
import Tech_Nagendra.Certificates_genration.Entity.Report;
import Tech_Nagendra.Certificates_genration.Entity.Template;
import Tech_Nagendra.Certificates_genration.Entity.UserProfile;
import Tech_Nagendra.Certificates_genration.Repository.ProfileRepository;
import Tech_Nagendra.Certificates_genration.Repository.ReportRepository;
import Tech_Nagendra.Certificates_genration.Repository.TemplateRepository;
import Tech_Nagendra.Certificates_genration.Security.UserPrincipal;
import jakarta.transaction.Transactional;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportService {
    @Autowired
    private ReportRepository reportRepository;
    @Autowired
    private ProfileRepository profileRepository;
    @Autowired
    private TemplateRepository templateRepository;

    private boolean isAdmin(UserPrincipal user) {
        return user != null && user.getAuthorities().stream().anyMatch(a -> a.getAuthority().equalsIgnoreCase("ADMIN") || a.getAuthority().equalsIgnoreCase("ROLE_ADMIN"));
    }

    private boolean hasRollId1(UserPrincipal user) {
        return user != null && user.getUserProfile() != null && user.getUserProfile().getRollid() != null && user.getUserProfile().getRollid() == 1L;
    }

    public List<Report> getAllReports(UserPrincipal currentUser) {
        if (currentUser == null) {
            return Collections.emptyList();
        }
        if (this.isAdmin(currentUser) || this.hasRollId1(currentUser)) {
            return this.reportRepository.findAll();
        }
        return this.reportRepository.findByGeneratedBy_Id(currentUser.getId());
    }

    public List<Report> getReportsByDateRange(Date startDate, Date endDate, UserPrincipal currentUser) {
        if (currentUser == null) {
            return Collections.emptyList();
        }
        Date adjustedStartDate = this.adjustStartDate(startDate);
        Date adjustedEndDate = this.adjustEndDate(endDate);
        if (this.isAdmin(currentUser) || this.hasRollId1(currentUser)) {
            return this.reportRepository.findByGeneratedOnBetween(adjustedStartDate, adjustedEndDate);
        }
        return this.reportRepository.findByGeneratedBy_IdAndGeneratedOnBetween(currentUser.getId(), adjustedStartDate, adjustedEndDate);
    }

    public List<ReportDTO> getReportDTOsByDateRange(Date startDate, Date endDate, UserPrincipal currentUser) {
        List reports = this.getReportsByDateRange(startDate, endDate, currentUser);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return reports.stream().map(r -> this.convertToReportDTO(r, sdf)).collect(Collectors.toList());
    }

    public List<ReportDTO> getReportsByMultipleFilters(Date startDate, Date endDate, String status, String searchTerm, UserPrincipal currentUser) {
        List reports = startDate != null && endDate != null ? this.getReportsByDateRange(startDate, endDate, currentUser) : this.getAllReports(currentUser);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return reports.stream().filter(r -> status == null || r.getStatus() != null && r.getStatus().equalsIgnoreCase(status)).filter(r -> searchTerm == null || r.getSid() != null && r.getSid().toLowerCase().contains(searchTerm.toLowerCase()) || r.getCandidateName() != null && r.getCandidateName().toLowerCase().contains(searchTerm.toLowerCase()) || r.getTemplateName() != null && r.getTemplateName().toLowerCase().contains(searchTerm.toLowerCase()) || r.getBatchId() != null && r.getBatchId().toLowerCase().contains(searchTerm.toLowerCase()) || r.getTrainingPartner() != null && r.getTrainingPartner().toLowerCase().contains(searchTerm.toLowerCase())).map(r -> this.convertToReportDTO(r, sdf)).collect(Collectors.toList());
    }

    public Map<String, Object> getCertificateStatsByDateRange(Date startDate, Date endDate, UserPrincipal currentUser) {
        List reports = this.getReportsByDateRange(startDate, endDate, currentUser);
        HashMap<String, Object> stats = new HashMap<String, Object>();
        stats.put("totalCertificates", reports.size());
        stats.put("successfulCertificates", reports.stream().filter(r -> "GENERATED".equals(r.getStatus())).count());
        stats.put("failedCertificates", reports.stream().filter(r -> "FAILED".equals(r.getStatus())).count());
        Map<String, Long> templateDistribution = reports.stream().collect(Collectors.groupingBy(r -> r.getTemplateName() != null ? r.getTemplateName() : "Unknown", Collectors.counting()));
        stats.put("templateDistribution", templateDistribution);
        Map<String, Long> dailyStats = reports.stream().filter(r -> r.getGeneratedOn() != null).collect(Collectors.groupingBy(r -> {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            return sdf.format(r.getGeneratedOn());
        }, Collectors.counting()));
        stats.put("dailyStats", dailyStats);
        return stats;
    }

    private Date adjustStartDate(Date startDate) {
        if (startDate == null) {
            Calendar cal = Calendar.getInstance();
            cal.add(5, -30);
            return cal.getTime();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    private Date adjustEndDate(Date endDate) {
        if (endDate == null) {
            return new Date();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(endDate);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    private ReportDTO convertToReportDTO(Report report, SimpleDateFormat sdf) {
        ReportDTO dto = new ReportDTO();
        dto.setId(report.getId());
        dto.setSid(report.getSid());
        dto.setCourseName(report.getCandidateName());
        dto.setGrade(report.getGrade());
        dto.setTemplateName(report.getTemplateName());
        dto.setJobrole(report.getJobrole());
        dto.setLevel(report.getLevel());
        dto.setBatchId(report.getBatchId());
        dto.setTrainingPartner(report.getTrainingPartner());
        dto.setGeneratedById(report.getGeneratedBy() != null ? report.getGeneratedBy().getId() : null);
        dto.setUserProfileId(report.getUserProfile() != null ? report.getUserProfile().getId() : null);
        dto.setTemplateId(report.getTemplate() != null ? report.getTemplate().getId() : null);
        dto.setStatus(report.getStatus());
        dto.setGeneratedOn(report.getGeneratedOn() != null ? sdf.format(report.getGeneratedOn()) : null);
        return dto;
    }

    public Report getReportById(Long id) {
        return this.reportRepository.findById((Object)id).orElse(null);
    }

    @Transactional
    public Report saveOrUpdateBySid(Report report, UserPrincipal currentUser) {
        if (currentUser == null) {
            return null;
        }
        Long templateId = this.getTemplateIdFromReport(report);
        List existingReports = new ArrayList();
        if (report.getSid() != null && templateId != null) {
            existingReports = this.reportRepository.findAllBySidAndTemplateId(report.getSid(), templateId);
        }
        if (!existingReports.isEmpty()) {
            Report existing = (Report)existingReports.get(0);
            existing.setCandidateName(report.getCandidateName());
            existing.setGrade(report.getGrade());
            existing.setJobrole(report.getJobrole());
            existing.setLevel(report.getLevel());
            existing.setBatchId(report.getBatchId());
            existing.setTrainingPartner(report.getTrainingPartner());
            existing.setTemplateName(report.getTemplateName());
            existing.setSid(report.getSid());
            existing.setGeneratedOn(new Date());
            existing.setGeneratedBy(currentUser.getUserProfile());
            existing.setStatus(report.getStatus() != null ? report.getStatus() : "GENERATED");
            existing.setActive(Boolean.valueOf(true));
            if (report.getTemplate() != null) {
                existing.setTemplate(report.getTemplate());
            }
            if (existingReports.size() > 1) {
                System.out.println("Warning: " + (existingReports.size() - 1) + " duplicate reports exist for SID=" + report.getSid() + " TemplateID=" + templateId);
            }
            return (Report)this.reportRepository.save((Object)existing);
        }
        if (report.getUserProfile() == null) {
            report.setUserProfile(currentUser.getUserProfile());
        }
        report.setGeneratedBy(currentUser.getUserProfile());
        report.setGeneratedOn(new Date());
        report.setStatus(report.getStatus() != null ? report.getStatus() : "GENERATED");
        report.setActive(Boolean.valueOf(true));
        if (report.getTemplate() == null && templateId != null) {
            Template template = this.templateRepository.findById((Object)templateId).orElse(null);
            report.setTemplate(template);
        }
        return (Report)this.reportRepository.save((Object)report);
    }

    private Long getTemplateIdFromReport(Report report) {
        if (report.getTemplate() != null && report.getTemplate().getId() != null) {
            return report.getTemplate().getId();
        }
        return null;
    }

    @Transactional
    public void saveOrUpdateAllBySid(List<Report> reports, UserPrincipal currentUser) {
        if (currentUser == null) {
            return;
        }
        for (Report report : reports) {
            this.saveOrUpdateBySid(report, currentUser);
        }
    }

    @Transactional
    public List<Report> generateCertificates(UserPrincipal currentUser, List<Long> templateIds, String sid) {
        if (currentUser == null || templateIds == null) {
            return Collections.emptyList();
        }
        ArrayList<Report> reports = new ArrayList<Report>();
        for (Long templateId : templateIds) {
            Report report = new Report();
            Template template = this.templateRepository.findById((Object)templateId).orElse(null);
            if (template != null) {
                report.setTemplate(template);
                report.setTemplateName((String)(template.getTemplateName() != null ? template.getTemplateName() : "Template ID: " + templateId));
            } else {
                report.setTemplateName("Template ID: " + templateId);
            }
            report.setSid(sid);
            report.setUserProfile(currentUser.getUserProfile());
            reports.add(this.saveOrUpdateBySid(report, currentUser));
        }
        return reports;
    }

    @Transactional
    public Report saveCandidateReport(Object candidateDTO, Long templateId, Long userId, UserPrincipal currentUser) {
        if (currentUser == null) {
            return null;
        }
        UserProfile targetUserProfile = (UserProfile)this.profileRepository.findById((Object)userId).orElseThrow(() -> new RuntimeException("User not found with ID: " + userId));
        String sid = this.extractSidFromCandidateDTO(candidateDTO);
        List existingReports = this.reportRepository.findAllBySidAndTemplateId(sid, templateId);
        if (!existingReports.isEmpty()) {
            Report existing = (Report)existingReports.get(0);
            existing.setGeneratedOn(new Date());
            existing.setGeneratedBy(currentUser.getUserProfile());
            existing.setStatus("GENERATED");
            return (Report)this.reportRepository.save((Object)existing);
        }
        Report report = new Report();
        Template template = this.templateRepository.findById((Object)templateId).orElse(null);
        if (template != null) {
            report.setTemplate(template);
            report.setTemplateName((String)(template.getTemplateName() != null ? template.getTemplateName() : "Template ID: " + templateId));
        } else {
            report.setTemplateName("Template ID: " + templateId);
        }
        report.setUserProfile(targetUserProfile);
        report.setGeneratedBy(currentUser.getUserProfile());
        report.setGeneratedOn(new Date());
        report.setStatus("GENERATED");
        return (Report)this.reportRepository.save((Object)report);
    }

    private String extractSidFromCandidateDTO(Object candidateDTO) {
        if (candidateDTO == null) {
            return null;
        }
        try {
            return candidateDTO.getClass().getMethod("getSid", new Class[0]).invoke(candidateDTO, new Object[0]).toString();
        }
        catch (Exception e) {
            return candidateDTO.toString();
        }
    }

    public Long getTotalCertificatesCount(UserPrincipal currentUser) {
        if (currentUser == null) {
            return 0L;
        }
        return this.isAdmin(currentUser) || this.hasRollId1(currentUser) ? this.reportRepository.count() : this.reportRepository.countByGeneratedBy_Id(currentUser.getId());
    }

    public Long countCertificatesThisMonth() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date start = cal.getTime();
        Date end = new Date();
        return this.reportRepository.countByGeneratedOnBetween(start, end);
    }

    public Long countCertificatesThisMonthByUser(Long userId) {
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date start = cal.getTime();
        Date end = new Date();
        return this.reportRepository.countByGeneratedBy_IdAndGeneratedOnBetween(userId, start, end);
    }

    public Map<String, Long> getMonthlyCertificateStats() {
        List allReports = this.reportRepository.findAll();
        return allReports.stream().filter(r -> r.getGeneratedOn() != null).collect(Collectors.groupingBy(r -> {
            Calendar c = Calendar.getInstance();
            c.setTime(r.getGeneratedOn());
            return c.get(1) + "-" + String.format("%02d", c.get(2) + 1);
        }, Collectors.counting()));
    }

    public Map<String, Long> getMonthlyCertificateStatsByUser(Long userId) {
        List reports = this.reportRepository.findByGeneratedBy_Id(userId);
        return reports.stream().filter(r -> r.getGeneratedOn() != null).collect(Collectors.groupingBy(r -> {
            Calendar c = Calendar.getInstance();
            c.setTime(r.getGeneratedOn());
            return c.get(1) + "-" + String.format("%02d", c.get(2) + 1);
        }, Collectors.counting()));
    }

    public Map<String, Long> getCertificateTypesDistribution(UserPrincipal currentUser) {
        List reports = this.isAdmin(currentUser) || this.hasRollId1(currentUser) ? this.reportRepository.findAll() : this.reportRepository.findByGeneratedBy_Id(currentUser.getId());
        return reports.stream().collect(Collectors.groupingBy(r -> r.getTemplateName() != null ? r.getTemplateName() : "Unknown", Collectors.counting()));
    }

    public Map<String, Long> getTotalTemplatesCount(UserPrincipal currentUser) {
        return this.getCertificateTypesDistribution(currentUser);
    }

    public List<ReportDTO> getReportsByFilter(String status, String searchTerm, Date from, Date to, UserPrincipal currentUser) {
        List reports = from != null && to != null ? this.getReportsByDateRange(from, to, currentUser) : this.getAllReports(currentUser);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return reports.stream().filter(r -> status == null || r.getStatus() != null && r.getStatus().equalsIgnoreCase(status)).filter(r -> searchTerm == null || r.getSid() != null && r.getSid().toLowerCase().contains(searchTerm.toLowerCase()) || r.getCandidateName() != null && r.getCandidateName().toLowerCase().contains(searchTerm.toLowerCase()) || r.getTemplateName() != null && r.getTemplateName().toLowerCase().contains(searchTerm.toLowerCase())).filter(r -> from == null || r.getGeneratedOn() != null && !r.getGeneratedOn().before(from)).filter(r -> to == null || r.getGeneratedOn() != null && !r.getGeneratedOn().after(to)).map(r -> this.convertToReportDTO(r, sdf)).collect(Collectors.toList());
    }
}

