/*
 * Decompiled with CFR 0.152.
 */
package Tech_Nagendra.Certificates_genration.Service;

import Tech_Nagendra.Certificates_genration.Dto.TemplateDto;
import Tech_Nagendra.Certificates_genration.Entity.Template;
import Tech_Nagendra.Certificates_genration.Entity.TemplateImage;
import Tech_Nagendra.Certificates_genration.Entity.UserProfile;
import Tech_Nagendra.Certificates_genration.Repository.ProfileRepository;
import Tech_Nagendra.Certificates_genration.Repository.TemplateImageRepository;
import Tech_Nagendra.Certificates_genration.Repository.TemplateRepository;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class TemplateService {
    private final TemplateRepository templateRepository;
    private final TemplateImageRepository templateImageRepository;
    private final ProfileRepository profileRepository;
    private static final String TEMPLATE_BASE_PATH = System.getProperty("user.dir") + "/templates/";

    public TemplateDto saveTemplate(Long userId, String templateName, Integer imageType, MultipartFile[] jrxmlFiles, MultipartFile[] images) throws IOException {
        File templateFolder;
        if (templateName == null || templateName.trim().isEmpty()) {
            throw new IllegalArgumentException("Template name cannot be empty");
        }
        templateName = templateName.trim();
        UserProfile currentUser = (UserProfile)this.profileRepository.findById((Object)userId).orElseThrow(() -> new RuntimeException("Logged-in user not found"));
        File baseDir = new File(TEMPLATE_BASE_PATH);
        if (!baseDir.exists()) {
            baseDir.mkdirs();
        }
        if (!(templateFolder = new File(baseDir, templateName)).exists()) {
            templateFolder.mkdirs();
        }
        ArrayList<String> jrxmlPaths = new ArrayList<String>();
        if (jrxmlFiles != null) {
            for (MultipartFile multipartFile : jrxmlFiles) {
                if (multipartFile.isEmpty()) continue;
                File jrxmlFile = new File(templateFolder, multipartFile.getOriginalFilename());
                multipartFile.transferTo(jrxmlFile);
                jrxmlPaths.add(jrxmlFile.getAbsolutePath());
            }
        }
        Template template = new Template();
        template.setTemplateName(templateName);
        template.setImageType(imageType);
        template.setTemplateFolder(templateFolder.getAbsolutePath());
        template.setJrxmlPath(String.join((CharSequence)",", jrxmlPaths));
        template.setCreatedBy(currentUser);
        template.setModifiedBy(currentUser);
        template.setCreatedAt(LocalDateTime.now());
        template.setModifiedAt(LocalDateTime.now());
        Template savedTemplate = (Template)this.templateRepository.save((Object)template);
        ArrayList<TemplateImage> savedImages = new ArrayList<TemplateImage>();
        if (images != null) {
            for (MultipartFile image : images) {
                if (image.isEmpty()) continue;
                File imgFile = new File(templateFolder, image.getOriginalFilename());
                image.transferTo(imgFile);
                TemplateImage ti = new TemplateImage();
                ti.setTemplate(savedTemplate);
                ti.setImagePath(imgFile.getAbsolutePath());
                ti.setImageType(imageType);
                savedImages.add((TemplateImage)this.templateImageRepository.save((Object)ti));
            }
        }
        savedTemplate.setImages(savedImages);
        List list = savedImages.stream().map(TemplateImage::getImagePath).collect(Collectors.toList());
        return this.mapToDto(savedTemplate, list);
    }

    public TemplateDto getTemplateByIdForUser(Long templateId, Long userId, String role) throws Exception {
        Template template = (Template)this.templateRepository.findById((Object)templateId).orElseThrow(() -> new RuntimeException("Template not found"));
        if (!"ADMIN".equalsIgnoreCase(role) && !template.getCreatedBy().getId().equals(userId)) {
            throw new RuntimeException("You do not have access to this template");
        }
        List imagePaths = template.getImages().stream().map(TemplateImage::getImagePath).collect(Collectors.toList());
        return this.mapToDto(template, imagePaths);
    }

    public List<TemplateDto> getAllTemplates(Long userId, String role) {
        List templates = "ADMIN".equalsIgnoreCase(role) ? this.templateRepository.findAll() : this.templateRepository.findByCreatedBy_Id(userId);
        return templates.stream().map(template -> this.mapToDto(template, template.getImages().stream().map(TemplateImage::getImagePath).collect(Collectors.toList()))).collect(Collectors.toList());
    }

    public Long getTotalTemplates(Long userId, String role) {
        return "ADMIN".equalsIgnoreCase(role) ? this.templateRepository.count() : this.templateRepository.countByCreatedBy_Id(userId).longValue();
    }

    private TemplateDto mapToDto(Template template, List<String> imagePaths) {
        return new TemplateDto(template.getId(), template.getTemplateName(), template.getImageType(), template.getJrxmlPath(), template.getTemplateFolder(), template.getCreatedAt(), template.getModifiedAt(), imagePaths);
    }

    public TemplateService(TemplateRepository templateRepository, TemplateImageRepository templateImageRepository, ProfileRepository profileRepository) {
        this.templateRepository = templateRepository;
        this.templateImageRepository = templateImageRepository;
        this.profileRepository = profileRepository;
    }
}

