/*
 * Decompiled with CFR 0.152.
 */
package Tech_Nagendra.Certificates_genration.Utility;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.io.Decoders;
import io.jsonwebtoken.security.Keys;
import jakarta.annotation.PostConstruct;
import java.security.Key;
import java.util.Date;
import javax.crypto.SecretKey;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class JwtUtil {
    @Value(value="${app.jwt.secret}")
    private String jwtSecretBase64;
    private SecretKey signingKey;

    @PostConstruct
    public void init() {
        try {
            byte[] keyBytes = (byte[])Decoders.BASE64.decode((Object)this.jwtSecretBase64);
            this.signingKey = Keys.hmacShaKeyFor((byte[])keyBytes);
        }
        catch (Exception e) {
            throw new IllegalStateException("Invalid JWT secret key", e);
        }
    }

    public String generateToken(Long userId, String username, String email, String role) {
        if (userId == null || username == null) {
            throw new IllegalArgumentException("userId and username cannot be null for JWT generation");
        }
        return Jwts.builder().setSubject(username).claim("userId", (Object)userId).claim("email", (Object)(email != null ? email : "")).claim("role", (Object)(role != null ? role : "")).setIssuedAt(new Date()).setExpiration(new Date(System.currentTimeMillis() + 604800000L)).signWith((Key)this.signingKey, SignatureAlgorithm.HS256).compact();
    }

    public Claims extractAllClaims(String token) {
        if ((token = this.cleanToken(token)).isEmpty()) {
            throw new IllegalArgumentException("JWT token is missing");
        }
        try {
            return (Claims)Jwts.parserBuilder().setSigningKey((Key)this.signingKey).build().parseClaimsJws(token).getBody();
        }
        catch (JwtException e) {
            throw new IllegalArgumentException("Invalid JWT token: " + e.getMessage());
        }
    }

    public String cleanToken(String token) {
        if (token == null) {
            return "";
        }
        if ((token = token.trim()).startsWith("Bearer ")) {
            token = token.substring(7);
        }
        return token.replaceAll("[^\\x20-\\x7E]", "");
    }

    public Long extractUserId(String token) {
        Object userIdObj = this.extractAllClaims(token).get((Object)"userId");
        if (userIdObj == null) {
            throw new IllegalArgumentException("JWT token missing 'userId' claim");
        }
        if (userIdObj instanceof Integer) {
            return ((Integer)userIdObj).longValue();
        }
        if (userIdObj instanceof Long) {
            return (Long)userIdObj;
        }
        return Long.parseLong(userIdObj.toString());
    }

    public String extractUsername(String token) {
        String username = this.extractAllClaims(token).getSubject();
        if (username == null) {
            throw new IllegalArgumentException("JWT token missing 'username' (subject)");
        }
        return username;
    }

    public String extractEmail(String token) {
        Object email = this.extractAllClaims(token).get((Object)"email");
        return email != null ? email.toString() : "";
    }

    public String extractRole(String token) {
        Object role = this.extractAllClaims(token).get((Object)"role");
        return role != null ? role.toString() : "";
    }

    public boolean isTokenExpired(String token) {
        Date expiration = this.extractAllClaims(token).getExpiration();
        return expiration.before(new Date());
    }

    public boolean validateToken(String token, String username) {
        try {
            String extractedUsername = this.extractUsername(token);
            return extractedUsername.equals(username) && !this.isTokenExpired(token);
        }
        catch (Exception e) {
            return false;
        }
    }
}

